% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.R
\name{sampleLeafVarianceOneIteration}
\alias{sampleLeafVarianceOneIteration}
\title{Sample Leaf Scale}
\usage{
sampleLeafVarianceOneIteration(forest, rng, a, b)
}
\arguments{
\item{forest}{C++ forest}

\item{rng}{C++ random number generator}

\item{a}{Leaf variance shape parameter}

\item{b}{Leaf variance scale parameter}
}
\value{
None
}
\description{
Sample one iteration of the leaf parameter variance model (only for univariate basis and constant leaf!)

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
num_trees <- 100
leaf_dimension <- 1
is_leaf_constant <- TRUE
is_exponentiated <- FALSE
active_forest <- createForest(num_trees, leaf_dimension, is_leaf_constant, is_exponentiated)
rng <- createCppRNG(1234)
a <- 1.0
b <- 1.0
tau <- sampleLeafVarianceOneIteration(active_forest, rng, a, b)
}
