% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R, R/wrappers.R
\docType{data}
\name{svsample_fast_cpp}
\alias{svsample_fast_cpp}
\alias{svsample_general_cpp}
\alias{default_fast_sv}
\alias{default_general_sv}
\title{Bindings to \code{C++} Functions in \code{stochvol}}
\format{
An object of class \code{list} of length 11.

An object of class \code{list} of length 5.
}
\usage{
svsample_fast_cpp(
  y,
  draws = 1,
  burnin = 0,
  designmatrix = NA,
  priorspec = specify_priors(),
  thinpara = 1,
  thinlatent = 1,
  keeptime = "all",
  startpara,
  startlatent,
  keeptau = !inherits(priorspec$nu, "sv_infinity"),
  print_settings = list(quiet = TRUE, n_chains = 1, chain = 1),
  correct_model_misspecification = FALSE,
  interweave = TRUE,
  myoffset = 0,
  fast_sv = default_fast_sv
)

svsample_general_cpp(
  y,
  draws = 1,
  burnin = 0,
  designmatrix = NA,
  priorspec = specify_priors(),
  thinpara = 1,
  thinlatent = 1,
  keeptime = "all",
  startpara,
  startlatent,
  keeptau = !inherits(priorspec$nu, "sv_infinity"),
  print_settings = list(quiet = TRUE, n_chains = 1, chain = 1),
  correct_model_misspecification = FALSE,
  interweave = TRUE,
  myoffset = 0,
  general_sv = default_general_sv
)

default_fast_sv

default_general_sv
}
\arguments{
\item{y}{numeric vector of the observations}

\item{draws}{single positive integer, the number of draws to
return (after the burn-in)}

\item{burnin}{single positive integer, length of warm-up
period, this number of draws are discarded from the beginning}

\item{designmatrix}{numeric matrix of covariates. Dimensions:
\code{length(y)} times the number of covariates. If there are
no covariates then this should be \code{matrix(NA)}}

\item{priorspec}{a \code{priorspec} object created by
\link{specify_priors}}

\item{thinpara}{single number greater or equal to 1, coercible to integer.
Every \code{thinpara}th parameter draw is kept and returned. The default
value is 1, corresponding to no thinning of the parameter draws i.e. every
draw is stored.}

\item{thinlatent}{single number greater or equal to 1, coercible to integer.
Every \code{thinlatent}th latent variable draw is kept and returned. The
default value is 1, corresponding to no thinning of the latent variable
draws, i.e. every draw is kept.}

\item{keeptime}{Either 'all' (the default) or 'last'. Indicates which latent
volatility draws should be stored.}

\item{startpara}{named list, containing the starting values
for the parameter draws. It must contain
elements
 * mu: an arbitrary numerical value
 * phi: real number between \code{-1} and \code{1}
 * sigma: a positive real number
 * nu: a number larger than \code{2}; can be \code{Inf}
 * rho: real number between \code{-1} and \code{1}
 * beta: a numeric vector of the same length as the number of covariates
 * latent0: either \code{'stationary'} or a positive number denoting the
     prior variance of \code{h0}}

\item{startlatent}{vector of length \code{length(y)},
containing the starting values for the latent log-volatility draws.}

\item{keeptau}{Logical value indicating whether the 'variance inflation
factors' should be stored (used for the sampler with conditional t
innovations only). This may be useful to check at what point(s) in time the
normal disturbance had to be 'upscaled' by a mixture factor and when the
series behaved 'normally'.}

\item{print_settings}{List of three elements:
 * quiet: logical value indicating whether the progress bar and other
informative output during sampling should be omitted
 * n_chains: number of independent MCMC chains
 * chain: index of this chain
Please note that this function does not run multiple independent chains
but \code{svsample} offers different printing functionality depending on
whether it is executed as part of several MCMC chains in parallel
(chain specific messages) or simply as a single chain (progress bar).}

\item{correct_model_misspecification}{Logical value. If \code{FALSE},
then auxiliary mixture sampling is used to sample the latent
states. If \code{TRUE}, extra computations are made to correct for model
misspecification either ex-post by reweighting or on-line using a
Metropolis-Hastings step.}

\item{interweave}{Logical value. If \code{TRUE},
then ancillarity-sufficiency interweaving strategy (ASIS) is applied
to improve on the sampling efficiency for the parameters.
Otherwise one parameterization is used.}

\item{myoffset}{Single non-negative number that is used in
\code{log(y^2 + myoffset)} to prevent \code{-Inf} values in the auxiliary
mixture sampling scheme.}

\item{fast_sv}{named list of expert settings. We recommend the use of \code{default_fast_sv}.}

\item{general_sv}{named list of expert settings. We recommend the use of \code{default_general_sv}.}
}
\description{
All the heavy lifting in \code{stochvol} is implemented in \code{C++}
with the help of \code{R} packages \code{Rcpp} and \code{RcppArmadillo}.
These functions call the MCMC samplers in \code{C++} directly without any
any validation and transformations, expert use only!
}
\details{
The sampling functions are separated into fast SV and general SV. See more details
in the sections below.
}
\section{Fast SV}{

Fast SV was developed in Kastner and Fruehwirth-Schnatter (2014). Fast SV estimates an
approximate SV model without leverage, where the approximation comes in through
auxiliary mixture approximations to the exact SV model. The sampler uses
the ancillarity-sufficiency interweaving strategy (ASIS) to improve on the sampling
efficiency of the model parameters, and it employs all-without-a-loop (AWOL)
for computationally efficient Kalman filtering of the conditionally Gaussian state space.
Correction for model misspecification happens as a post-processing step.

Fast SV employs sampling strategies that have been fine-tuned and specified for
vanilla SV (no leverage), and hence it can be fast and efficient but also more limited
in its feature set. The conditions for the fast SV sampler: \code{rho == 0}; \code{mu}
has either a normal prior or it is also constant \code{0}; the prior for \code{phi}
is a beta distribution; the prior for \code{sigma^2} is either a gamma distribution
with shape \code{0.5} or a mean- and variance-matched inverse gamma distribution;
either \code{keeptime == 'all'} or \code{correct_model_misspecification == FALSE}.
These criteria are NOT VALIDATED by fast SV on the \code{C++} level!
}

\section{General SV}{

General SV also estimates an
approximate SV model without leverage, where the approximation comes in through
auxiliary mixture approximations to the exact SV model. The sampler uses
both ASIS and AWOL.

General SV employs adapted random walk Metropolis-Hastings as the proposal for
the parameters \code{mu}, \code{phi}, \code{sigma}, and \code{rho}. Therefore,
more general prior distributions are allowed in this case.
}

\keyword{datasets}
