% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structurednessindices.R
\name{c_functionality}
\alias{c_functionality}
\title{c-functionality
calculates the c-functionality based on the maximum edge value 
We define c-functionality as the aggregated functionality between any two columns of confs}
\usage{
c_functionality(
  confs,
  aggr = max,
  alpha = 1,
  C = 15,
  var.thr = 1e-05,
  zeta = NULL
)
}
\arguments{
\item{confs}{a numeric matrix or data frame}

\item{aggr}{the aggregation function for configurations of more than two dimensions. Defaults to mean}

\item{alpha}{an optional number of cells allowed in the X-by-Y search-grid. Default value is 1}

\item{C}{an optional number determining the starting point of the X-by-Y search-grid. When trying to partition the x-axis into X columns, the algorithm will start with at most C X clumps. Default value is 15.}

\item{var.thr}{minimum value allowed for the variance of the input variables, since mine can not be computed in case of variance close to 0. Default value is 1e-5.}

\item{zeta}{integer in [0,1] (?).  If NULL (default) it is set to 1-MIC. It can be set to zero for noiseless functions, but the default choice is the most appropriate parametrization for general cases (as stated in Reshef et al.). It provides robustness.}
}
\value{
a numeric value; functionality (aggregated maximaum edge value MEV, see \code{\link[minerva]{mine}})
}
\description{
c-functionality
calculates the c-functionality based on the maximum edge value 
We define c-functionality as the aggregated functionality between any two columns of confs
}
\examples{
x<-seq(-3,3,length.out=200)
y<-sqrt(3^2-x^2)
z<- sin(y-x)
confs<-cbind(x,y,z)
c_functionality(confs)
}
