% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_dist}
\alias{od_dist}
\title{Quickly calculate Euclidean distances of od pairs}
\usage{
od_dist(flow, zones)
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link{cents}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link{flow}}.}

\item{zones}{A SpatialPolygonsDataFrame or SpatialPointsDataFrame
representing origins and destinations of travel flows.}
}
\description{
It is common to want to know the Euclidean distance between origins and destinations
in OD data. You can calculate this by first converting OD data to SpatialLines data,
e.g. with \code{\link{od2line}}. However this can be slow and overkill if you just
want to know the distance. This function is a few orders of magnitude faster.
}
\details{
Note: this function assumes that the zones or centroids in \code{cents} have a geographic
(lat/lon) CRS.
}
\examples{
data(flow)
data(cents)
od_dist(flow, cents)
}

