% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_funs.R
\name{sp_aggregate}
\alias{sp_aggregate}
\title{Aggregate SpatialPolygonsDataFrame to new geometry.}
\usage{
sp_aggregate(zones, aggzones, cols = FALSE, FUN = sum,
  prop_by_area = ifelse(identical(FUN, mean) == FALSE, TRUE, FALSE),
  digits = getOption("digits"))
}
\arguments{
\item{zones}{A SpatialPolygonsDataFrame or SpatialPointsDataFrame
representing the original centroids or boundaries.
Note that in the case of a SpatialPointsDataFrame, the original value
will be allocated to the polygon in which the point is located rather than
being distributed by area.}

\item{aggzones}{A SpatialPolygonsDataFrame containing the new
boundaries to aggregate to.}

\item{cols}{A character vector containing the names of columns on which to
apply FUN. By default, all numeric columns are aggregated.}

\item{FUN}{Function to use on aggregation. Default is sum.}

\item{prop_by_area}{Boolean value indicating if the values should be
proportionally adjusted based on area. Default is TRUE unless FUN = mean.}

\item{digits}{The number of digits to use when proportionally adjusting
values based on area. Default is the value of getOption("digits").}
}
\value{
SpatialPolygonsDataFrame
}
\description{
Aggregate SpatialPolygonsDataFrame to new geometry.
}
\section{Details}{

This function performs aggregation on a SpatialPolygonsDataFrame to a
different geometry specified by another SpatialPolygons object.
}
\examples{
data(flow)
data(zones)
zones@data$region <- 1
zones@data[c(2, 5), c('region')] <- 2
aggzones <- SpatialPolygonsDataFrame(rgeos::gUnaryUnion(
 zones,
 id = zones@data$region), data.frame(region=c(1, 2))
)
zones@data$region <- NULL
zones@data$exdata <- 5
sp_aggregate(zones, aggzones)
}

