% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_segment}
\alias{line_segment}
\title{Divide SpatialLines dataset into regular segments}
\usage{
line_segment(l, n_segments, segment_length = NA)
}
\arguments{
\item{l}{A spatial lines object}

\item{n_segments}{The number of segments to divide the line into}

\item{segment_length}{The approximate length of segments in the output (overides n_segments if set)}
}
\description{
Divide SpatialLines dataset into regular segments
}
\examples{
data(routes_fast)
l = routes_fast[2, ]
library(sp)
l_seg2 = line_segment(l = l, n_segments = 2)
plot(l_seg2, col = l_seg2$group, lwd = 50)
}
