% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-functions.R
\name{dist_google}
\alias{dist_google}
\title{Return travel network distances and time using the Google Maps API}
\usage{
dist_google(from, to, google_api = Sys.getenv("GOOGLEDIST"),
  g_units = "metric", mode = c("bicycling", "walking", "driving",
  "transit"), arrival_time = "")
}
\arguments{
\item{from}{Two-column matrix or data frame of coordinates representing
latitude and longitude of origins.}

\item{to}{Two-column matrix or data frame of coordinates representing
latitude and longitude of destinations.}

\item{google_api}{String value containing the Google API key to use.}

\item{g_units}{Text string, either metric (default) or imperial.}

\item{mode}{Text string specifying the mode of transport. Can be
bicycling (default), walking, driving or transit}

\item{arrival_time}{Time of arrival in date format.}
}
\description{
Return travel network distances and time using the Google Maps API
}
\details{
Absent authorization, the google API is limited to a maximum of 100
simultaneous queries, and so will, for example, only returns values for up to
10 origins times 10 destinations.
}
\section{Details}{

Estimate travel times accounting for the road network - see \url{https://developers.google.com/maps/documentation/distance-matrix/}
Note: Currently returns the json object returned by the Google Maps API and uses the same origins and destinations.
}

\examples{
\dontrun{
# Distances from one origin to one destination
from <- c(-46.3, -23.4)
to <- c(-46.4, -23.4)
dist_google(from = from, to = to, mode = "walking") # not supported on last test
dist_google(from = from, to = to, mode = "driving")
dist_google(from = c(0, 52), to = c(0, 53))
data("cents")
# Distances from between all origins and destinations
dists_cycle <- dist_google(from = cents, to = cents)
dists_drive <- dist_google(cents, cents, mode = "driving")
dists_trans <- dist_google(cents, cents, mode = "transit")
dists_trans_am <- dist_google(cents, cents,
  mode = "transit",
  arrival_time = strptime("2016-05-27 09:00:00",
    format = "\%Y-\%m-\%d \%H:\%M:\%S", tz = "BST"
  )
)
# Find out how much longer (or shorter) cycling takes than walking
summary(dists_cycle$duration / dists_trans$duration)
# Difference between travelling now and for 9am arrival
summary(dists_trans_am$duration / dists_trans$duration)
odf <- points2odf(cents)
odf <- cbind(odf, dists)
head(odf)
flow <- points2flow(cents)
# show the results for duration (thicker line = shorter)
plot(flow, lwd = mean(odf$duration) / odf$duration)
dist_google(c("Hereford"), c("Weobley", "Leominster", "Kington"))
dist_google(c("Hereford"), c("Weobley", "Leominster", "Kington"),
  mode = "transit", arrival_time = strptime("2016-05-27 17:30:00",
    format = "\%Y-\%m-\%d \%H:\%M:\%S", tz = "BST"
  )
)
}
}
