% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\name{route_dodgr}
\alias{route_dodgr}
\title{Route on local data using the dodgr package}
\usage{
route_dodgr(from = NULL, to = NULL, l = NULL, net = NULL)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}

\item{net}{sf object representing the route network}
}
\description{
Route on local data using the dodgr package
}
\examples{
if (requireNamespace("dodgr")) {
  from <- c(-1.5327, 53.8006) # from <- geo_code("pedallers arms leeds")
  to <- c(-1.5279, 53.8044) # to <- geo_code("gzing")
  # next 4 lines were used to generate `stplanr::osm_net_example`
  # pts <- rbind(from, to)
  # colnames(pts) <- c("X", "Y")
  # net <- dodgr::dodgr_streetnet(pts = pts, expand = 0.1)
  # osm_net_example <- net[c("highway", "name", "lanes", "maxspeed")]
  r <- route_dodgr(from, to, net = osm_net_example)
  plot(osm_net_example$geometry)
  plot(r$geometry, add = TRUE, col = "red", lwd = 5)
}
}
\seealso{
Other routes: 
\code{\link{line2routeRetry}()},
\code{\link{line2route}()},
\code{\link{route_graphhopper}()},
\code{\link{route_local}()},
\code{\link{route_transportapi_public}()},
\code{\link{route}()}
}
\concept{routes}
