% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_coords2line}
\alias{od_coords2line}
\title{Convert origin-destination coordinates into desire lines}
\usage{
od_coords2line(odc, crs = 4326, remove_duplicates = TRUE)
}
\arguments{
\item{odc}{A data frame or matrix representing the coordinates
of origin-destination data. The first two columns represent the
coordinates of the origin (typically longitude and latitude) points;
the third and fourth columns represent the coordinates of the destination
(in the same CRS). Each row represents travel from origin to destination.}

\item{crs}{A number representing the coordinate reference system
of the result, 4326 by default.}

\item{remove_duplicates}{Should rows with duplicated rows be removed? \code{TRUE} by default.}
}
\description{
Convert origin-destination coordinates into desire lines
}
\examples{
odf <- od_coords(l = flowlines_sf)
odlines <- od_coords2line(odf)
odlines <- od_coords2line(odf, crs = 4326)
plot(odlines)
x_coords = 1:3
n = 50
d = data.frame(lapply(1:4, function(x) sample(x_coords, n, replace = TRUE)))
names(d) = c("fx", "fy", "tx", "ty")
l = od_coords2line(d)
plot(l)
nrow(l)
l_with_duplicates = od_coords2line(d, remove_duplicates = FALSE)
plot(l_with_duplicates)
nrow(l_with_duplicates)
}
\seealso{
Other od: 
\code{\link{dist_google}()},
\code{\link{od2line}()},
\code{\link{od2odf}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords}()},
\code{\link{od_dist}()},
\code{\link{od_id}},
\code{\link{od_oneway}()},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
