% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_funs.R
\name{route_average_gradient}
\alias{route_average_gradient}
\title{Return average gradient across a route}
\usage{
route_average_gradient(elevations, distances)
}
\arguments{
\item{elevations}{Elevations, e.g. those provided by the \code{cyclestreets} package}

\item{distances}{Distances, e.g. those provided by the \code{cyclestreets} package}
}
\description{
This function assumes that elevations and distances are in the same units.
}
\examples{
r1 <- od_data_routes[od_data_routes$route_number == 2, ]
elevations <- r1$elevations
distances <- r1$distances
route_average_gradient(elevations, distances) # an average of a 4\% gradient
}
\seealso{
Other route_funs: 
\code{\link{route_rolling_average}()},
\code{\link{route_rolling_diff}()},
\code{\link{route_rolling_gradient}()},
\code{\link{route_sequential_dist}()},
\code{\link{route_slope_matrix}()},
\code{\link{route_slope_vector}()}
}
\concept{route_funs}
