% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_coords.R
\name{extract_coords}
\alias{extract_coords}
\title{Coordinates extraction}
\usage{
extract_coords(poly)
}
\arguments{
\item{poly}{(An sf or S4 object)
A polygon shapefile.}
}
\value{
Returns 2-column xy coordinates
representing points of directional
change along the boundary.
}
\description{
Extracts the bounding (edges) coordinates
of a polygon object.
}
\details{
Given a spatial polygon object,
the function extracts its bounding coordinates.
}
\examples{
#load boundary of Camden
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
boundary = camden$boundary # get boundary
extract_coords(poly=boundary)
}
