% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{abind<-}
\alias{abind<-}
\title{Add array slices to 3D+ Array
\code{`abind<-`} adds array slices to arrays as a side effect. It used the function
\code{abind} in the \code{abind} package. The purpose of the function is to replace
the need to use ary2 <- abind(ary1, mat1); ary3 <- rbind(ary2, mat2); ary4 <- rbind(ary3, mat3),
etc. It allows you to specify the dimension you wish to bind \code{along} as well as the dimname you
wish to bind \code{after}. Unlike \code{`cbind<-`}, \code{`rbind<-`}, and \code{`append<-`},
it does not have overwriting functionality (I could not figure out how to code that);
therefore, if \code{value} has some dimnames that are the same as those in \code{a},
it will NOT overwrite them and simply bind them to \code{a}, resulting in duplicate
dimnames.}
\usage{
abind(
  a,
  along = ndim(a),
  after = dim(a)[along],
  dim.nm = NULL,
  overwrite = FALSE
) <- value
}
\arguments{
\item{a}{3D+ array.}

\item{along}{either an integer vector with length 1 or a character vector of
length 1 specifying the dimension along which to bind \code{value}. If an integer
vector, it is the position of the dimension. If a character vector it is the
dimension with that dimlabel.}

\item{after}{either an integer vector with length 1 or a character vector of
length 1 specifying where to add \code{value} within the dimension specified by
\code{along}. If an integer vector, it is the position within the dimension.
If a character vector it is the dimname within the dimension. Similar to
\code{append}, use 0L if you want the added array slice to be first.}

\item{dim.nm}{character vector of length equal to \code{ndim(value)[along]} that
specifies the dimnames of \code{value} once added to \code{a} as array slices.
This is an optional argument that defaults to NULL where the pre-existing dimnames
of \code{value} are used.}

\item{overwrite}{not currently used, but there are plans to use it in future
versions of the functions. Right now the only option is FALSE.}

\item{value}{matrix or array to be added as slices to \code{a}. Must have ndim
equal to \code{ndim(a)} or \code{ndim(a) - 1L}. Note, the dimensions have to match
those in \code{a}. For example, if \code{value} is a matrix you want to bind
along the third dimension of \code{a}, then \code{dim(value)} must be equal to
\code{dim(a)[1:2]}. If not, you will get an error from \code{abind::abind}.}
}
\value{
Like other similar functions (e.g., \code{`names<-`} and \code{`[<-`}),
\code{`rbind<-`} does not appear to have a return object. However, it technically
does as a side effect. The argument \code{data} will have been changed such that
\code{value} has been added as rows. If a traditional return object is desired,
and no side effects, then it can be called like a traditional function:
dat2 <- `rbind<-`(dat1, value = add1).
}
\description{
Some traditional R folks may find this function uncomfortable. R is famous for limiting
side effects, except for a few notable exceptions (e.g., \code{`[<-`} and \code{`names<-`}).
Part of the reason is that side effects can be computationally inefficient in R.
The entire object often has to be re-constructed and re-saved to memory. For
example, a more computationally efficient alternative to abind(ary) <- mat1;
abind(ary) <- mat2; abind(ary) <- mat3 is ary1 <- do.call(what = abind,
args = list(ary, mat1, mat2, mat3)). However, \code{`abind<-`} was not created
for R programming use when computational efficiency is valued; it is created
for R interactive use when user convenience is valued.
}
\examples{
# abind along the last dimension
# default `along` and `after`
HairEyeColor2 <- HairEyeColor
intersex_ary <- array(1:16, dim = c(4,4,1), dimnames = list(NULL, NULL, "Sex" = "Intersex"))
abind(HairEyeColor2) <- intersex_ary
print(HairEyeColor2)
# user-specified `along` and `after`
HairEyeColor2 <- HairEyeColor
intersex_ary <- array(1:16, dim = c(4,4,1), dimnames = list(NULL, NULL, "Sex" = "Intersex"))
abind(HairEyeColor2, along = "Sex", after = 0L) <- intersex_ary
print(HairEyeColor2)
# matrix as `value`
HairEyeColor2 <- HairEyeColor
intersex_mat <- matrix(1:16, nrow = 4, ncol = 4)
abind(HairEyeColor2, dim.nm = "Intersex") <- intersex_mat
print(HairEyeColor2)

# abind along the first dimension
# array as `value`
HairEyeColor2 <- HairEyeColor
auburn_ary <- array(1:8, dim = c(1,4,2), dimnames = list("Hair" = "Auburn", NULL, NULL))
abind(HairEyeColor2, along = 1L) <- auburn_ary
print(HairEyeColor2)
# matrix as `value`
HairEyeColor2 <- HairEyeColor
auburn_mat <- matrix(1:8, nrow = 4, ncol = 2) # rotate 90-degrees counter-clockwise in your mind
abind(HairEyeColor2, along = 1L, dim.nm = "Auburn") <- auburn_mat
print(HairEyeColor2)
# `after` in the middle
HairEyeColor2 <- HairEyeColor
auburn_mat <- matrix(1:8, nrow = 4, ncol = 2) # rotate 90-degrees counter-clockwise in your mind
abind(HairEyeColor2, along = 1L, after = 2L, dim.nm = "Auburn") <- auburn_mat
print(HairEyeColor2)

# abind along the second dimension
# array as `value`
HairEyeColor2 <- HairEyeColor
amber_ary <- array(1:8, dim = c(4,1,2), dimnames = list(NULL, "Eye" = "Amber", NULL))
abind(HairEyeColor2, along = 2L) <- amber_ary
print(HairEyeColor2)
# matrix as `value`
HairEyeColor2 <- HairEyeColor
amber_mat <- matrix(1:8, nrow = 4, ncol = 2)
abind(HairEyeColor2, along = 2L, dim.nm = "Amber") <- amber_mat
print(HairEyeColor2)
# `after` in the middle
HairEyeColor2 <- HairEyeColor
amber_mat <- matrix(1:8, nrow = 4, ncol = 2)
abind(HairEyeColor2, along = 2L, after = "Blue", dim.nm = "Amber") <- amber_mat
print(HairEyeColor2)
}
