% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{lv2v}
\alias{lv2v}
\title{List of (atomic) Vectors to (atomic) Vector}
\usage{
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE, sep = "_", check = TRUE)
}
\arguments{
\item{lv}{list of (atomic) vectors.}

\item{use.listnames}{logical vector of length 1 specifying whether the names of
\code{lv} should be used to construct names for the returned vector. If \code{lv}
does not have names and \code{use.listnames} = TRUE, then the list positions will
be used as names (i.e., "1","2","3", etc.).}

\item{use.vecnames}{logical vector of length 1 specifying whether the names of
each vector within \code{lv} should be used to construct names for the returned vector.
If any vectors within \code{lv} do not have names and \code{use.vecnames} = TRUE,
then the vector positions will be used as names (i.e., "1","2","3", etc.).}

\item{sep}{character vector of length 1 specifying what string to use to separate
list names from vector element names. Only used if \code{use.listnames} = TRUE.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{lv} is a list of atomic
vectors. This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
atomic vector with length = sum of the lengths of the atomic vectors in
\code{lv} and typeof = the highest typeof present in the atomic vectors in \code{lv}
(i.e., from high to low: character > double > integer > logical). See the argument
\code{use.listnames} for how names are created.
}
\description{
\code{lv2v} converts a list of (atomic) vectors to an (atomic) vector. \code{lv2v}
is simply a wrapper function for \code{unlist} that allows for more control
over the names of the returned (atomic) vector.
}
\details{
There are four different scenarios. Each scenario is given as well as the structure
of the returned object when both \code{use.listnames} and \code{use.vecnames} are
TRUE (default): 1) if both \code{lv} and its vectors have names, then the names of
the return object will be a pasted combination of the \code{lv} element's name
and the vector element's name separated by \code{sep}; 2) if only \code{lv} has
names and its vectors do not, then the names of the returned vector will be a
pasted combination of the \code{lv} element's name and the vector element's position
separated by \code{sep}; 3) if the vectors have names and \code{lv} does not,
then the names of the returned vector will be a pasted combination of the \code{lv}
positions and vector names separated by \code{sep}; 4) if both \code{lv} and its
vectors do not have names, then the names of the returned vector will be the pasted
combination of the \code{lv} positions and vector element's positions separated
by \code{sep}.

If you want to convert a list of vectors where each vector has length = 1 and the
list has names, then you probably want to specify \code{use.vecnames} = FALSE.
This will replicate the functionality of \code{unlist(lv)}. See the last example.

If you want have a list of vectors where each vector has length > 1 and you
want to convert it to a list vector (i.e., all vectors with length = 1),
then you can combine \code{lv2v} with \code{v2lv} via \code{v2lv(lv2v(v))}.
}
\examples{
# 1) both `lv` and its atomic vectors have names
lv <- setNames(object = Map(object = 1:26, nm = letters, f = setNames), nm = LETTERS)
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE)
lv2v(lv, use.listnames = FALSE, use.vecnames = TRUE)
lv2v(lv, use.listnames = TRUE, use.vecnames = FALSE)
lv2v(lv, use.listnames = FALSE, use.vecnames = FALSE)
# 2) only `lv` has names
lv <- list("lower" = letters, "upper" = LETTERS)
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE)
lv2v(lv, use.listnames = FALSE, use.vecnames = TRUE)
lv2v(lv, use.listnames = TRUE, use.vecnames = FALSE) # FYI - results in repeat names
lv2v(lv, use.listnames = FALSE, use.vecnames = FALSE)
# 3) only the atomic vectors have names
lv <- list(setNames(object = 1:26, nm = letters), setNames(object = 1:26, nm = LETTERS))
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE)
lv2v(lv, use.listnames = FALSE, use.vecnames = TRUE)
lv2v(lv, use.listnames = TRUE, use.vecnames = FALSE)
lv2v(lv, use.listnames = FALSE, use.vecnames = FALSE)
# 4) neither `lv` nor its atomic vectors have names
lv <- as.list(1:26)
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE)
lv2v(lv, use.listnames = FALSE, use.vecnames = TRUE) # FYI - results in repeat names
lv2v(lv, use.listnames = TRUE, use.vecnames = FALSE)
lv2v(lv, use.listnames = FALSE, use.vecnames = FALSE)
# common use case for when vectors are all length 1 and list has names
lv <- setNames(as.list(letters), nm = LETTERS)
lv2v(lv, use.listnames = TRUE, use.vecnames = TRUE)
lv2v(lv, use.listnames = FALSE, use.vecnames = TRUE)
lv2v(lv, use.listnames = TRUE, use.vecnames = FALSE) # FYI - probably what you want
lv2v(lv, use.listnames = FALSE, use.vecnames = FALSE)
identical(unlist(lv), lv2v(lv, use.vecnames = FALSE)) # identical to unlist()
}
