% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_anomalies.R
\name{get_anomalies}
\alias{get_anomalies}
\title{Retrieve anomalies}
\usage{
get_anomalies(x, rank.prop = 0.05, nmin = 10, nmax = 300,
  stack.use = "avg", method.use = "norm", verbose = TRUE, ...)
}
\arguments{
\item{x}{stranger object (before of after singularize)}

\item{rank.prop}{proportion of records to be considered as anomalies}

\item{nmin}{constraint - minimum number of anomalies}

\item{nmax}{constrait - maximum number of anomalies}

\item{stack.use}{One of c("max","avg","min","damavg", "pruavg")) - must have been requestedwhen invoking `singularize` (done by default).}

\item{method.use}{One of c("norm","rank") - must have been requestedwhen invoking `singularize` (done by default).}

\item{verbose}{logical: provide some information.}

\item{...}{additional parameters to pass
to singularize (if called on a non-singularized object)

Anomalies selection is performed using one summary metric. This summary metrics is assumed to stacked some base metrics - may be only one!. Stacking is performed after standardisation, being possible with two approaches: normalisation (\code{method.use} = "norm") or ranking (\code{method.use} = "rank"). See \code{\link{singularize}} function.

Three parameters are used together to define anomalies: rank.prop is firsu used to filter on top x\% anomalies then one applies on top of this criteria conditions on a minimal (\code{nmin}) and maximal (\code{nmax}) number of anomalies to be provided.}
}
\description{
Based on a summary normalized/stacked metric, retrieve top anomalies.
}
\examples{
data <- crazyfy(iris[,1:4])
(anom <- get_anomalies(strange(data)))
\dontrun{
library(dplyr)
ss <- iris \%>\% select(-Species) \%>\%
 crazyfy() \%>\%
 strange(weird="autoencode") \%>\%
 singularize(methods="norm",stacks="avg")
 anom2 <- ss \%>\% get_anomalies(nmin=2, nmax=4)
 ss \%>\% plot(type="n",score="N_anom_norm_avg",anomaly_id=anom2[1])
}
}
