% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/align.mafft.R
\name{align.mafft}
\alias{align.mafft}
\title{MAFFT Alignment}
\usage{
align.mafft(x, run.label = "align.mafft", delete.output = TRUE, op = 3,
  ep = 0.123, maxiterate = 0, quiet = FALSE, num.cores = 1,
  opts = "--auto")
}
\arguments{
\item{x}{a \code{\link{gtypes}} object with aligned sequences or a list of aligned DNA sequences.}

\item{run.label}{label for output alignment FASTA file.}

\item{delete.output}{logical. Delete output alignment FASTA file?}

\item{op}{gap opening penalty.}

\item{ep}{offset value, which works like gap extension penalty.}

\item{maxiterate}{number cycles of iterative refinement are performed.}

\item{quiet}{logical. Run MAFFT quietly?}

\item{num.cores}{number of cores to be used. Passed to MAFFT argument \code{--thread}.}

\item{opts}{character string other options to provide to command line.}
}
\value{
list of aligned sequences
}
\description{
MAFFT Alignment
}
\note{
Formats and executes a call to the executable \code{mafft}, assuming that is installed
  on the system and available at the command line.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
MAFFT is available at: \url{http://mafft.cbrc.jp/alignment/software}
}

