% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/structure.plot.R
\name{structure.plot}
\alias{structure.plot}
\title{Plot STRUCTURE Results}
\usage{
structure.plot(q.mat, pop.col = 3, prob.col = 4, sort.probs = TRUE,
  label.pops = TRUE, col = NULL, ...)
}
\arguments{
\item{q.mat}{matrix or data.frame of assignment probabilities.}

\item{pop.col}{column number identifying original population designations.}

\item{prob.col}{column number of first assignment probabilities to first group.
It is assumed that the remainder of columns (\code{prob.col:ncol(q.mat)}) contain
all assignment probabilities, and thus \emph{k} = \code{ncol(q.mat) - prob.col + 1}.}

\item{sort.probs}{logical. Sort individuals by probabilities within populations?
If \code{FALSE} individuals will be plotted as in \code{q.mat}.}

\item{label.pops}{logical. Label the populations on the plot? If \code{FALSE}, then
population labels are omitted so the user can customize their format.}

\item{col}{colors to use for each group.}

\item{...}{optional arguments to be passed to \code{\link[graphics]{barplot}}.}
}
\value{
invisibly, a list containing:
\tabular{ll}{
  \code{q.mat} \tab the sorted matrix or data.frame of assignment probabilities used in the plot.\cr
  \code{bar.centers} \tab a vector of the centers of bars for each individual.\cr
  \code{pop.ticks} \tab a vector of the tick marks separating populations.\cr
 }
}
\description{
Plot Q-matrix from a call to \code{\link{structure.run}} or \code{\link{clumpp.run}}.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{structure}}, \code{\link{clumpp}}
}

