% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iupac.R
\name{iupac}
\alias{iupac}
\alias{iupacCode}
\alias{validIupacCodes}
\alias{iupacMat}
\title{IUPAC Codes}
\usage{
iupacCode(bases, ignore.gaps = FALSE)

validIupacCodes(bases)

iupacMat()
}
\arguments{
\item{bases}{character vector containing valid nucleotides or IUPAC codes.}

\item{ignore.gaps}{logical. Ignore gaps at a site when creating consensus. 
If true, then bases with a gap are removed before consensus is calculated. 
If false and a gap is present, then the result is a gap.}
}
\value{
\tabular{ll}{
  \code{iupacCode} \tab a character representing the correct IUPAC code 
    \code{bases}.\cr
  \code{validIupacCodes} \tab a character vector of all valid IUPAC 
    codes for \code{bases}.\cr
  \code{iupacMat} \tab a logical matrix identifying valid IUPAC codes.\cr
}
}
\description{
Calculate the correct IUPAC code for a vector of nucleotides.
}
\examples{
iupacCode(c("a", "a", "g"))

iupacCode(c("t", "c", "g"))

validIupacCodes(c("c", "t", "c", "c"))

validIupacCodes(c("c", "y", "c", "c"))

validIupacCodes(c("a", "g", "t", "a"))

}
\seealso{
\code{\link{validIupacCodes}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
