/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.AbstractClassifier;
import moa.classifiers.AttributeClassObserver;
import moa.classifiers.AttributeSplitSuggestion;
import moa.classifiers.GaussianNumericAttributeClassObserver;
import moa.classifiers.NominalAttributeClassObserver;
import moa.classifiers.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.IntOption;
import weka.core.Instance;

public class DecisionStump
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances to observe between model changes.", 1000, 0, Integer.MAX_VALUE);
    public FlagOption binarySplitsOption = new FlagOption("binarySplits", 'b', "Only allow binary splits.");
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 'c', "Split criterion to use.", SplitCriterion.class, "InfoGainSplitCriterion");
    protected AttributeSplitSuggestion bestSplit;
    protected DoubleVector observedClassDistribution;
    protected AutoExpandVector<AttributeClassObserver> attributeObservers;
    protected double weightSeenAtLastSplit;

    public void resetLearningImpl() {
        this.bestSplit = null;
        this.observedClassDistribution = new DoubleVector();
        this.attributeObservers = new AutoExpandVector();
        this.weightSeenAtLastSplit = 0.0;
    }

    protected Measurement[] getModelMeasurementsImpl() {
        return null;
    }

    public void getModelDescription(StringBuilder out, int indent) {
    }

    public void trainOnInstanceImpl(Instance inst) {
        this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            int instAttIndex = DecisionStump.modelAttIndexToInstanceAttIndex(i, inst);
            AttributeClassObserver obs = this.attributeObservers.get(i);
            if (obs == null) {
                obs = inst.attribute(instAttIndex).isNominal() ? this.newNominalClassObserver() : this.newNumericClassObserver();
                this.attributeObservers.set(i, obs);
            }
            obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
        }
        if (this.trainingWeightSeenByModel - this.weightSeenAtLastSplit >= (double)this.gracePeriodOption.getValue()) {
            this.bestSplit = this.findBestSplit((SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption));
            this.weightSeenAtLastSplit = this.trainingWeightSeenByModel;
        }
    }

    public double[] getVotesForInstance(Instance inst) {
        int branch;
        if (this.bestSplit != null && (branch = this.bestSplit.splitTest.branchForInstance(inst)) >= 0) {
            return this.bestSplit.resultingClassDistributionFromSplit(branch);
        }
        return this.observedClassDistribution.getArrayCopy();
    }

    public boolean isRandomizable() {
        return false;
    }

    protected AttributeClassObserver newNominalClassObserver() {
        return new NominalAttributeClassObserver();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        return new GaussianNumericAttributeClassObserver();
    }

    protected AttributeSplitSuggestion findBestSplit(SplitCriterion criterion) {
        AttributeSplitSuggestion bestFound = null;
        double bestMerit = Double.NEGATIVE_INFINITY;
        double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
        for (int i = 0; i < this.attributeObservers.size(); ++i) {
            AttributeClassObserver obs = this.attributeObservers.get(i);
            if (obs == null) continue;
            AttributeSplitSuggestion suggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitDist, i, this.binarySplitsOption.isSet());
            if (!(suggestion.merit > bestMerit)) continue;
            bestMerit = suggestion.merit;
            bestFound = suggestion;
        }
        return bestFound;
    }
}

