% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_ExponentialMA.R
\name{DSF_ExponentialMA}
\alias{DSF_ExponentialMA}
\title{Exponential Moving Average over a Data Stream}
\usage{
DSF_ExponentialMA(dsd = NULL, dim = NULL, alpha = 0.5)
}
\arguments{
\item{dsd}{The input stream as an \link{DSD} object.}

\item{dim}{columns to which the filter should be applied. Default is all columns.}

\item{alpha}{smoothing coefficient in \eqn{[0, 1]}. Larger means discounting older observations faster.}
}
\value{
An object of class \code{DSF_ExponentialMA} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Applies an exponential moving average to components of a data stream.
}
\details{
The exponential moving average is calculated by:

\eqn{S_t = \alpha Y_t + (1 - \alpha)\; S_{i-1}}

with \eqn{S_0 = Y_0}.
}
\examples{
# Smooth a time series
data(presidents)

stream <- data.frame(
    presidents,
    .time = time(presidents)) \%>\%
  DSD_Memory()

plot(stream, dim = 1, n = 120, method = "ts", main = "Original")

smoothStream <- stream \%>\% DSF_ExponentialMA(alpha = .7)
smoothStream

reset_stream(smoothStream)
plot(smoothStream, dim = 1, n = 120, method = "ts", main = "With ExponentialMA(.7)")
}
\seealso{
Other DSF: 
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_Scale}()},
\code{\link{DSF_dplyr}()},
\code{\link{DSF}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
