% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSAggregate.R
\name{DSAggregate}
\alias{DSAggregate}
\alias{update.DSAggregate}
\alias{get_points.DSAggregate}
\alias{get_weights.DSAggregate}
\title{Data Stream Aggregator Base Classes}
\usage{
DSAggregate(...)

\method{update}{DSAggregate}(object, dsd, n = 1, return = c("nothing", "model"), ...)

\method{get_points}{DSAggregate}(x, ...)

\method{get_weights}{DSAggregate}(x, ...)
}
\arguments{
\item{...}{Further arguments.}

\item{dsd}{a data stream object.}

\item{n}{the number of data points used for the update.}

\item{return}{a character string indicating what update returns. The default is \code{"nothing"}
and \code{"model"} returns the aggregated data.}

\item{x, object}{a concrete implementation of \code{DSAggregate}.}
}
\description{
Abstract base classes for all DSAggregate (Data Stream Aggregator) classes to aggregate streams. DSAggreagate is a \link{DST} task.
}
\details{
The \code{DSAggreagate} class cannot be instantiated, but it serve as a base
class from which other DSAggregate subclasses inherit.

Data stream operators use \code{update.DSAggregate()} to process new data from the
\link{DSD} stream. The result of the operator can be obtained via \code{\link[=get_points]{get_points()}}
and \code{\link[=get_weights]{get_weights()}} (if available).
}
\examples{
DSAggregate()
}
\seealso{
Other DST: 
\code{\link{DSC}()},
\code{\link{DSClassifier}()},
\code{\link{DSOutlier}()},
\code{\link{DSRegressor}()},
\code{\link{DST}()},
\code{\link{DST_SlidingWindow}()},
\code{\link{DST_WriteStream}()},
\code{\link{evaluate}},
\code{\link{predict}()},
\code{\link{stream_pipeline}},
\code{\link{update}()}

Other DSAggregate: 
\code{\link{DSAggregate_Sample}()},
\code{\link{DSAggregate_Window}()}
}
\author{
Michael Hahsler
}
\concept{DSAggregate}
\concept{DST}
