/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.AbstractOption;

public class MultiChoiceOption
extends AbstractOption {
    private static final long serialVersionUID = 1L;
    protected String[] optionLabels;
    protected String[] optionDescriptions;
    protected int defaultOptionIndex;
    protected int chosenOptionIndex;

    public MultiChoiceOption(String name, char cliChar, String purpose, String[] optionLabels, String[] optionDescriptions, int defaultOptionIndex) {
        super(name, cliChar, purpose);
        if (optionLabels.length != optionDescriptions.length) {
            throw new IllegalArgumentException("Labels/descriptions mismatch.");
        }
        this.optionLabels = (String[])optionLabels.clone();
        this.optionDescriptions = (String[])optionDescriptions.clone();
        this.defaultOptionIndex = defaultOptionIndex;
        this.resetToDefault();
    }

    @Override
    public String getDefaultCLIString() {
        return this.optionLabels[this.defaultOptionIndex];
    }

    @Override
    public String getValueAsCLIString() {
        return this.getChosenLabel();
    }

    @Override
    public void setValueViaCLIString(String s) {
        try {
            this.setChosenIndex(Integer.parseInt(s.trim()));
        }
        catch (NumberFormatException nfe) {
            this.setChosenLabel(s);
        }
    }

    public void setChosenLabel(String label) {
        label = label.trim();
        for (int i = 0; i < this.optionLabels.length; ++i) {
            if (!this.optionLabels[i].equals(label)) continue;
            this.chosenOptionIndex = i;
            return;
        }
        throw new IllegalArgumentException("Label not recognised: " + label);
    }

    public void setChosenIndex(int index) {
        if (index < 0 || index >= this.optionLabels.length) {
            throw new IndexOutOfBoundsException();
        }
        this.chosenOptionIndex = index;
    }

    public String[] getOptionLabels() {
        return (String[])this.optionLabels.clone();
    }

    public String[] getOptionDescriptions() {
        return (String[])this.optionDescriptions.clone();
    }

    public int getDefaultOptionIndex() {
        return this.defaultOptionIndex;
    }

    public String getChosenLabel() {
        return this.optionLabels[this.chosenOptionIndex];
    }

    public int getChosenIndex() {
        return this.chosenOptionIndex;
    }
}

