/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.kmeanspm.ClusteringFeature;
import moa.clusterers.kmeanspm.ClusteringTreeHeadNode;
import moa.clusterers.kmeanspm.ClusteringTreeNode;
import moa.clusterers.kmeanspm.CoresetKMeans;
import moa.clusterers.kmeanspm.Metric;
import moa.core.AutoExpandVector;
import moa.core.Measurement;

public class BICO
extends AbstractClusterer {
    private static final long serialVersionUID = 1L;
    public IntOption numClustersOption = new IntOption("Cluster", 'k', "Number of desired centers.", 5, 1, Integer.MAX_VALUE);
    public IntOption numDimensionsOption = new IntOption("Dimensions", 'd', "Number of the dimensions of the input points.", 10, 1, Integer.MAX_VALUE);
    public IntOption maxNumClusterFeaturesOption = new IntOption("MaxClusterFeatures", 'n', "Maximum size of the coreset.", 1000, 1, Integer.MAX_VALUE);
    public IntOption numProjectionsOption = new IntOption("Projections", 'p', "Number of random projections used for the nearest neighbour search.", 10, 1, Integer.MAX_VALUE);
    protected int numClusters;
    protected int numDimensions;
    protected int maxNumClusterFeatures;
    protected int numProjections;
    private boolean bufferPhase;
    private List<double[]> buffer;
    private double minDistance;
    private int pairwiseDifferent;
    private ClusteringTreeNode root;
    private int rootCount;
    private double T;

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return true;
    }

    @Override
    public Clustering getMicroClusteringResult() {
        return this.root.addToClustering(new Clustering(new AutoExpandVector<Cluster>(this.rootCount)));
    }

    public void printMicroClusteringResult(Writer stream) throws IOException {
        this.root.printClusteringCenters(stream);
    }

    public int getMicroClusteringSize() {
        return this.rootCount;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Clustering getClusteringResult() {
        List<Object> microClustering;
        if (this.bufferPhase) {
            microClustering = new ArrayList(this.buffer.size());
            for (double[] pointA : this.buffer) {
                boolean duplicate = false;
                for (double[] dArray : microClustering) {
                    int i;
                    for (i = 0; i < pointA.length && pointA[i] == dArray[i + 1]; ++i) {
                    }
                    if (i != pointA.length) continue;
                    duplicate = true;
                    dArray[0] = dArray[0] + 1.0;
                    break;
                }
                if (duplicate) continue;
                double[] pointWeighted = new double[pointA.length + 1];
                pointWeighted[0] = 1.0;
                System.arraycopy(pointA, 0, pointWeighted, 1, pointA.length);
                microClustering.add(pointWeighted);
            }
        } else {
            microClustering = this.root.addToClusteringCenters(new ArrayList<double[]>(this.rootCount));
        }
        List<double[]> result = null;
        double minValue = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 5; ++i) {
            List<double[]> list = CoresetKMeans.generatekMeansPlusPlusCentroids(this.numClusters, microClustering, this.clustererRandom);
            double newValue = CoresetKMeans.kMeans(list, microClustering);
            if (!(newValue < minValue)) continue;
            result = list;
            minValue = newValue;
        }
        AutoExpandVector<Cluster> resultClustering = new AutoExpandVector<Cluster>(result.size());
        for (double[] point : result) {
            resultClustering.add(new SphereCluster(point, 0.0));
        }
        return new Clustering(resultClustering);
    }

    @Override
    public void resetLearningImpl() {
        this.numClusters = this.numClustersOption.getValue();
        this.numDimensions = this.numDimensionsOption.getValue();
        this.maxNumClusterFeatures = this.maxNumClusterFeaturesOption.getValue();
        this.numProjections = this.numProjectionsOption.getValue();
        this.bufferPhase = true;
        this.buffer = new ArrayList<double[]>(this.maxNumClusterFeaturesOption.getValue() + 1);
        this.minDistance = Double.POSITIVE_INFINITY;
        this.pairwiseDifferent = 0;
        int hashSize = (int)Math.ceil(Math.log(5 * this.maxNumClusterFeaturesOption.getValue()) / Math.log(2.0));
        this.root = new ClusteringTreeHeadNode(null, new ClusteringFeature(new double[0], 1.0), this.numDimensionsOption.getValue(), this.numProjectionsOption.getValue(), Math.min(hashSize, 30), this.clustererRandom);
        this.rootCount = 0;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        double[] x = inst.toDoubleArray();
        if (this.numDimensions != x.length) {
            System.out.println("Line skipped because line dimension is " + x.length + " instead of " + this.numDimensions);
            return;
        }
        if (this.bufferPhase) {
            for (double[] point : this.buffer) {
                double d = Metric.distanceSquared(point, x);
                if (!(d > 0.0)) continue;
                ++this.pairwiseDifferent;
                if (!(d < this.minDistance)) continue;
                this.minDistance = d;
            }
            this.buffer.add(x);
            if (this.pairwiseDifferent >= this.maxNumClusterFeatures + 1) {
                this.T = 16.0 * this.minDistance;
                this.root.setThreshold(this.calcRSquared(1));
                this.bufferPhase = false;
                for (double[] point : this.buffer) {
                    this.bicoUpdate(point);
                }
                this.buffer.clear();
                this.buffer = null;
            }
        } else {
            this.bicoUpdate(x);
        }
    }

    protected void bicoUpdate(double[] x) {
        assert (!this.bufferPhase && this.numDimensions == x.length);
        ClusteringTreeNode r = this.root;
        int i = 1;
        while (true) {
            ClusteringTreeNode y = r.nearestChild(x);
            if (r.hasNoChildren() || y == null || Metric.distanceSquared(x, y.getCenter()) > this.calcRSquared(i)) {
                r.addChild(new ClusteringTreeNode(x, new ClusteringFeature(x, this.calcR(i))));
                ++this.rootCount;
                break;
            }
            if (y.getClusteringFeature().calcKMeansCosts(y.getCenter(), x) <= this.T) {
                y.getClusteringFeature().add(1, x, Metric.distanceSquared(x));
                break;
            }
            r = y;
            ++i;
        }
        if (this.rootCount > this.maxNumClusterFeatures) {
            this.rebuild();
        }
    }

    protected void rebuild() {
        while (this.rootCount > this.maxNumClusterFeatures) {
            this.T *= 2.0;
            this.root.setThreshold(this.calcRSquared(1));
            LinkedList<ClusteringTreeNode> Q = new LinkedList<ClusteringTreeNode>();
            Q.addAll(this.root.getChildren());
            this.root.clearChildren();
            this.rootCount = 0;
            while (!Q.isEmpty()) {
                ClusteringTreeNode x = (ClusteringTreeNode)Q.element();
                Q.addAll(x.getChildren());
                x.clearChildren();
                this.bicoCFUpdate(x);
                Q.remove();
            }
        }
    }

    protected void bicoCFUpdate(ClusteringTreeNode x) {
        ClusteringTreeNode r = this.root;
        int i = 1;
        while (true) {
            ClusteringTreeNode y = r.nearestChild(x.getCenter());
            if (r.hasNoChildren() || y == null || Metric.distanceSquared(x.getCenter(), y.getCenter()) > this.calcRSquared(i)) {
                x.setThreshold(this.calcR(i));
                r.addChild(x);
                ++this.rootCount;
                break;
            }
            if (y.getClusteringFeature().calcKMeansCosts(y.getCenter(), x.getClusteringFeature()) <= this.T) {
                y.getClusteringFeature().merge(x.getClusteringFeature());
                break;
            }
            r = y;
            ++i;
        }
    }

    protected double calcRSquared(int level) {
        return this.T / (double)(1 << 3 + level);
    }

    protected double calcR(int level) {
        return Math.sqrt(this.calcRSquared(level));
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

