/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import weka.gui.ExtensionFileFilter;

public class ImagePanel
extends ChartPanel {
    JFreeChart chart;

    public ImagePanel(JFreeChart chart) {
        super(chart);
        this.chart = chart;
    }

    public void doSaveAs() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        ExtensionFileFilter filterPNG = new ExtensionFileFilter("PNG Image Files", ".png");
        fileChooser.addChoosableFileFilter((FileFilter)filterPNG);
        ExtensionFileFilter filterJPG = new ExtensionFileFilter("JPG Image Files", ".jpg");
        fileChooser.addChoosableFileFilter((FileFilter)filterJPG);
        ExtensionFileFilter filterEPS = new ExtensionFileFilter("EPS Image Files", ".eps");
        fileChooser.addChoosableFileFilter((FileFilter)filterEPS);
        ExtensionFileFilter filterSVG = new ExtensionFileFilter("SVG Image Files", ".svg");
        fileChooser.addChoosableFileFilter((FileFilter)filterSVG);
        fileChooser.setCurrentDirectory(null);
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String fileDesc = fileChooser.getFileFilter().getDescription();
            if (fileDesc.startsWith("PNG")) {
                if (!fileChooser.getSelectedFile().getName().toUpperCase().endsWith("PNG")) {
                    ChartUtilities.saveChartAsPNG((File)new File(fileChooser.getSelectedFile().getAbsolutePath() + ".png"), (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
                } else {
                    ChartUtilities.saveChartAsPNG((File)fileChooser.getSelectedFile(), (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
                }
            } else if (fileDesc.startsWith("JPG")) {
                if (!fileChooser.getSelectedFile().getName().toUpperCase().endsWith("JPG")) {
                    ChartUtilities.saveChartAsJPEG((File)new File(fileChooser.getSelectedFile().getAbsolutePath() + ".jpg"), (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
                } else {
                    ChartUtilities.saveChartAsJPEG((File)fileChooser.getSelectedFile(), (JFreeChart)this.chart, (int)this.getWidth(), (int)this.getHeight());
                }
            }
        }
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean copy, boolean save, boolean print, boolean zoom) {
        JPopupMenu result = new JPopupMenu(localizationResources.getString("Chart") + ":");
        boolean separator = false;
        if (properties) {
            JMenuItem propertiesItem = new JMenuItem(localizationResources.getString("Properties..."));
            propertiesItem.setActionCommand("PROPERTIES");
            propertiesItem.addActionListener((ActionListener)((Object)this));
            result.add(propertiesItem);
            separator = true;
        }
        if (copy) {
            if (separator) {
                result.addSeparator();
            }
            JMenuItem copyItem = new JMenuItem(localizationResources.getString("Copy"));
            copyItem.setActionCommand("COPY");
            copyItem.addActionListener((ActionListener)((Object)this));
            result.add(copyItem);
            boolean bl = separator = !save;
        }
        if (save) {
            if (separator) {
                result.addSeparator();
            }
            JMenu saveSubMenu = new JMenu(localizationResources.getString("Save_as"));
            JMenuItem pngItem = new JMenuItem(localizationResources.getString("PNG..."));
            separator = true;
        }
        if (print) {
            if (separator) {
                result.addSeparator();
            }
            JMenuItem printItem = new JMenuItem(localizationResources.getString("Print..."));
            printItem.setActionCommand("PRINT");
            printItem.addActionListener((ActionListener)((Object)this));
            result.add(printItem);
            separator = true;
        }
        return result;
    }
}

