/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.IntOption;
import com.github.javacliparser.StringOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.Example;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class ImbalancedStream
extends AbstractOptionHandler
implements InstanceStream {
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to imbalance.", ExampleStream.class, "generators.RandomTreeGenerator");
    public StringOption classRatioOption = new StringOption("classRatio", 'c', "Determine the ratio of each class in the output stream. The ratio of each class should be given as a real number between 0 and 1, each followed by a semicolon, and their sum should be equal to 1. The default value of \"0.9;0.1\" stands for an output stream with approximately 90% of the instances belonging to the first class and 10% to the second class.", "0.9;0.1");
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    protected ExampleStream originalStream = null;
    protected Instances[] instancesBuffer = null;
    protected double[] probPerClass = null;
    protected Random random = null;
    protected int numClasses = 0;

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        int i;
        this.originalStream = (ExampleStream)this.getPreparedClassOption(this.streamOption);
        this.numClasses = this.originalStream.getHeader().numClasses();
        this.probPerClass = new double[this.numClasses];
        this.instancesBuffer = new Instances[this.numClasses];
        this.probPerClass = new double[this.numClasses];
        double sumProbs = 0.0;
        String[] probs = this.classRatioOption.getValue().split(";");
        for (i = 0; i < probs.length; ++i) {
            if (i > this.probPerClass.length - 1) {
                throw new IllegalArgumentException("Please make sure the number of class ratios provided is less or equal the number of classes in the original stream.");
            }
            Double p = Double.parseDouble(probs[i]);
            if (!p.isNaN() && !p.isInfinite() && p >= 0.0 && p <= 1.0) {
                this.probPerClass[i] = p;
                sumProbs += p.doubleValue();
                continue;
            }
            throw new IllegalArgumentException("Please make sure only numbers between 0.0 and 1.0 are inputted.");
        }
        if (sumProbs != 1.0) {
            throw new IllegalArgumentException("Please make sure the class ratios sum up to 1.0.");
        }
        for (i = 0; i < this.instancesBuffer.length; ++i) {
            this.instancesBuffer[i] = new Instances(this.originalStream.getHeader());
        }
        this.random = new Random(this.instanceRandomSeedOption.getValue());
    }

    @Override
    public InstancesHeader getHeader() {
        return this.originalStream.getHeader();
    }

    @Override
    public long estimatedRemainingInstances() {
        return this.originalStream.estimatedRemainingInstances();
    }

    @Override
    public boolean hasMoreInstances() {
        return this.originalStream.hasMoreInstances();
    }

    @Override
    public Example<Instance> nextInstance() {
        int iClass = -1;
        for (double p = this.random.nextDouble(); p > 0.0; p -= this.probPerClass[++iClass]) {
        }
        while (this.instancesBuffer[iClass].size() == 0) {
            Object inst = this.originalStream.nextInstance();
            this.instancesBuffer[(int)((Instance)inst.getData()).classValue()].add((Instance)inst.getData());
        }
        Instance instance = this.instancesBuffer[iClass].get(0);
        this.instancesBuffer[iClass].delete(0);
        return new InstanceExample(instance);
    }

    @Override
    public boolean isRestartable() {
        return this.originalStream.isRestartable();
    }

    @Override
    public void restart() {
        this.random = new Random(this.instanceRandomSeedOption.getValue());
        this.originalStream.restart();
        for (int i = 0; i < this.instancesBuffer.length; ++i) {
            this.instancesBuffer[i] = new Instances(this.originalStream.getHeader());
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

