% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSOutlier_MCOD.R
\name{DSC_MCOD}
\alias{DSC_MCOD}
\alias{DSC_MCOD_MOA}
\alias{DSOutlier_MCOD}
\alias{DSOutlier_MCOD_MOA}
\alias{MCOD}
\alias{get_outlier_positions}
\alias{recheck_outlier}
\alias{clean_outliers}
\title{Micro-cluster Continuous Outlier Detector (MCOD)}
\usage{
DSC_MCOD(r = 0.1, t = 50, w = 1000, recheck_outliers = FALSE)

DSOutlier_MCOD(r = 0.1, t = 50, w = 1000, recheck_outliers = TRUE)

get_outlier_positions(x, ...)

recheck_outlier(x, outlier_correlated_id, ...)

clean_outliers(x, ...)
}
\arguments{
\item{r}{Defines the micro-cluster radius.}

\item{t}{Defines the number of neighbors (k in the article).}

\item{w}{Defines the window width in data points.}

\item{recheck_outliers}{Defines that the MCOD algorithm allows re-checking
of detected outliers.}

\item{x}{a \code{DSC_MCOD} object.}

\item{...}{further arguments are currently ignored.}

\item{outlier_correlated_id}{ids of outliers.}
}
\value{
An object of class \code{DSC_MCOD} (subclass of \link{DSOutlier},
\link{DSC_Micro}, \link{DSC_MOA} and \link{DSC}).
}
\description{
Class interfaces the MOA implementation of the MCOD algorithm for
distance-based data stream outlier detection.
}
\details{
The algorithm detects density-based outliers. An object \eqn{x} is defined
to be an outlier if there are less than \eqn{t} objects lying at distance at
most \eqn{r} from \eqn{x}.

Outliers are stored and can be retrieved using \code{get_outlier_position()} and
\code{recheck_outlier()}.

\strong{Note:} The implementation updates the clustering when \code{\link[=predict]{predict()}} is called.
}
\section{Functions}{
\itemize{
\item \code{get_outlier_positions()}: Returns spatial positions of all current outliers.

\item \code{recheck_outlier()}: DSC_MCOD Re-checks the outlier having \code{outlier_correlated_id}.
If this object is still an outlier, the method returns \code{TRUE}.

\item \code{clean_outliers()}: forget detected outliers from the outlier detector (currently not implemented).

}}
\examples{
# Example 1: Clustering with MCOD
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)
mcod <- DSC_MCOD(r = .1, t = 3, w = 100)
update(mcod, stream, 100)
mcod

plot(mcod, stream, n = 100)

# Example 2: Predict outliers (have a class label of NA)
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)
mcod <- DSOutlier_MCOD(r = .1, t = 3, w = 100)
update(mcod, stream, 100)

plot(mcod, stream, n = 100)

# MCOD can retried the outliers
get_outlier_positions(mcod)

# Example 3: evaluate on a stream
evaluate_static(mcod, stream, n = 100, type = "micro",
  measure = c("crand", "noisePrecision", "outlierjaccard"))
}
\references{
Kontaki M, Gounaris A, Papadopoulos AN, Tsichlas K, and
Manolopoulos Y (2016). Efficient and flexible algorithms for monitoring
distance-based outliers over data streams. \emph{Information Systems,} Vol.
55, pp. 37-53. \doi{10.1109/ICDE.2011.5767923}
}
\seealso{
Other DSC_MOA: 
\code{\link{DSC_BICO_MOA}()},
\code{\link{DSC_CluStream}()},
\code{\link{DSC_ClusTree}()},
\code{\link{DSC_DStream_MOA}()},
\code{\link{DSC_DenStream}()},
\code{\link{DSC_MOA}()},
\code{\link{DSC_StreamKM}()}
}
\author{
Dalibor Krleža
}
\concept{DSC_MOA}
\concept{DSOutlier_MOA}
