% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stressaddition-package.R
\docType{package}
\name{stressaddition-package}
\alias{stressaddition}
\alias{stressaddition-package}
\title{stressaddition: Modelling Tri-Phasic Concentration-Response Relationships}
\description{
The stress addition approach is an alternative to the traditional 
    concentration addition or effect addition models. It allows the modelling 
    of tri-phasic concentration-response relationships either as single toxicant 
    experiments, in combination with an environmental stressor or as mixtures of 
    two toxicants. See Liess et al. (2019) <doi:10.1038/s41598-019-51645-4>.
}
\details{
This R package contains the definitions of the
  \link[=ecxsys]{ECx-SyS} model and the \link[=multi_tox]{Multi-TOX} model.
  See the publications linked below for more information including equations.

  Author contributions: M. Liess conceived the ECx-SyS and Multi-TOX models.
  S. Henz developed this R package. N. Shahid contributed to the optimization
  of the Multi-TOX model and provided the \link{multiple_stress} data set.
}
\references{
\href{https://doi.org/10.1038/s41598-019-51645-4}{Liess, M.,
  Henz, S. & Knillmann, S. Predicting low-concentration effects of
  pesticides. Sci Rep 9, 15248 (2019).}

  Liess, M., Henz, S., Shahid, N., 2020. Modelling the synergistic effects of
  toxicant mixtures. Manuscript submitted for publication.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://git.ufz.de/oekotox/stressaddition}
}

}
\author{
\strong{Maintainer}: Sebastian Henz \email{bastihz.dev@posteo.de} (\href{https://orcid.org/0000-0001-8299-8852}{ORCID})

Authors:
\itemize{
  \item Matthias Liess (\href{https://orcid.org/0000-0002-3321-8909}{ORCID})
}

Other contributors:
\itemize{
  \item Naeem Shahid (\href{https://orcid.org/0000-0001-6581-1654}{ORCID}) [contributor]
  \item Helmholtz-Zentrum fuer Umweltforschung GmbH - UFZ [copyright holder, funder]
}

}
