% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singleize.R
\name{str_singleize}
\alias{str_singleize}
\title{Remove back-to-back duplicates of a pattern in a string.}
\usage{
str_singleize(string, pattern)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:stringi-search-regex]{stringi::stringi-search-regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:coll]{coll()}. For details see \code{\link[stringr:regex]{stringr::regex()}}.}
}
\value{
A character vector.
}
\description{
If a string contains a given pattern duplicated back-to-back a number of
times, remove that duplication, leaving the pattern appearing once in that
position (works if the pattern is duplicated in different parts of a string,
removing all instances of duplication). This is vectorized over string and
pattern.
}
\examples{
str_singleize("abc//def", "/")
str_singleize("abababcabab", "ab")
str_singleize(c("abab", "cdcd"), "cd")
str_singleize(c("abab", "cdcd"), c("ab", "cd"))
}
\seealso{
Other removers: \code{\link{str_remove_quoted}},
  \code{\link{str_trim_anything}}
}
\concept{removers}
