% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_extract_words}
\alias{stri_extract_words}
\title{Extract Words from a Text}
\usage{
stri_extract_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}.}
}
\value{
A list of character vectors is returned. Each string consists of
a separate word. If there are no words or if a string is missing,
a single \code{NA} is provided on output.
}
\description{
This function extracts all words from each string.
}
\details{
Vectorized over \code{str}.

Just like in the case of \code{\link{stri_locate_words}}
and \code{\link{stri_count_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This is function is equivalent to a call to
\code{\link{stri_split_boundaries}(str, \link{stri_opts_brkiter}(type="word", skip_word_none=TRUE, locale=locale))}
}
\examples{
\donttest{
stri_extract_words("stringi: THE string processing package 123.48...")
}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}

Other search_extract: \code{\link{stri_extract}},
  \code{\link{stri_extract_all}},
  \code{\link{stri_extract_all_charclass}},
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_all_regex}},
  \code{\link{stri_extract_first}},
  \code{\link{stri_extract_first_charclass}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_regex}},
  \code{\link{stri_extract_last}},
  \code{\link{stri_extract_last_charclass}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_regex}};
  \code{\link{stri_match}}, \code{\link{stri_match_all}},
  \code{\link{stri_match_all_regex}},
  \code{\link{stri_match_first}},
  \code{\link{stri_match_first_regex}},
  \code{\link{stri_match_last}},
  \code{\link{stri_match_last_regex}};
  \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search}}
}

