% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strucLegends.R
\name{defaultStrucLegend}
\alias{defaultStrucLegend}
\alias{displayStruc}
\title{Construct default structure legend to plot on a \code{strucplot}
display.}
\usage{
defaultStrucLegend(struc, legendLoc = c("top", "right", "bottom", "left",
  "newpage"), lbl = "PLOT STRUCTURE", heading = c("Horizontal", "Vertical"),
  miss = "None", cex.font = 1, cex.lbl = 1.25, col = "black",
  abbrevLength = 0, ...)

displayStruc(struc, miss = "No Conditioning", heading = c("Horizontal",
  "Vertical"), abbrevLength = 0)
}
\arguments{
\item{struc}{The "structure" attribute of a \code{strucplot} object}

\item{legendLoc}{One of c("top","right","bottom","left","newpage")
The first 4 specify on which side of the trellis display to place the legend.
The last indicates that the legend will be plotted at the center of a
separate page.}

\item{lbl}{A character string title for the legend. 
Default = \code{"PLOT STRUCTURE"}}

\item{heading}{A character vector of length 2 giving the headings for the 
horizontal and vertical conditioning variables portions of the legend.
Default = \code{c("Horizontal", "Vertical")}}

\item{miss}{A character string to use when a conditioning variable is absent.
Default = \code{"None"}}

\item{cex.font}{Multiplier for text font size. Default = 1}

\item{cex.lbl}{Multiplier for label font size. Default = 1.25}

\item{col}{Text color for text. Default = \code{"black"}}

\item{abbrevLength}{\code{minlength} argument for \code{\link{abbreviate}} 
function to abbreviate names of the conditioning factors. Default = 0 = no 
abbreviation.}

\item{...}{Additional arguments to be used in a \code{gp} list for
controlling text appearance. See \code{\link[grid]{gpar}} for possibilities.}
}
\value{
A text grob that can be included as part of the \code{strucplot}
trellis plot.
}
\description{
A structure legend is always printed on the console. It can also
be optionally added to the trellis plot. This non-exported function
constructs a default legend for this option.
}
\section{Functions}{
\itemize{
\item \code{displayStruc}: An auxiliary function that constructs the
character strings for the conditioning variables.
}}
\seealso{
\code{\link{print.structured}}
}

