% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateSpike.r
\name{calculateSpike}
\alias{calculateSpike}
\title{Detect Spike}
\usage{
calculateSpike(data, threshold = NULL, round.to = 1, kit = NULL,
  debug = FALSE)
}
\arguments{
\item{data}{data.frame with including colums 'Sample.Name', 'Marker', 'Size'.}

\item{threshold}{numeric number of peaks of similar size in different dye
channels to pass as a possible spike (NULL = number of dye channels
minus one to allow for on unlabelled peak).}

\item{round.to}{numeric toleranse for Size.}

\item{kit}{string or numeric for the STR-kit used (NULL = auto detect).}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame
}
\description{
Detect samples with possible spikes in the DNA profile.
}
\details{
Creates a list of possible spikes by searching for peaks aligned
vertically (i.e. nearly identical size).
}
\seealso{
\code{\link{data.table}}
}

