% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{import}
\alias{import}
\title{Import Data}
\usage{
import(folder = TRUE, extension = "txt", suffix = NA, prefix = NA,
  import.file = NA, folder.name = NA, file.name = TRUE,
  time.stamp = TRUE, separator = "\\t", ignore.case = TRUE,
  auto.trim = FALSE, trim.samples = NULL, trim.invert = FALSE,
  auto.slim = FALSE, slim.na = TRUE, na.strings = c("NA", ""),
  debug = FALSE)
}
\arguments{
\item{folder}{logical, TRUE all files in folder will be imported,
FALSE only selected file will be imported.}

\item{extension}{string providing the file extension.}

\item{suffix}{string, only files with specified suffix will be imported.}

\item{prefix}{string, only files with specified prefix will be imported.}

\item{import.file}{string if file name is provided file will be imported
without showing the file open dialogue.}

\item{folder.name}{string if folder name is provided files in folder
will be imported without showing the select folder dialogue.}

\item{file.name}{logical if TRUE the file name is written in a column 'File.Name'.
NB! Any existing 'File.Name' column is overwritten.}

\item{time.stamp}{logical if TRUE the file modified time stamp is written
in a column 'Time'.
NB! Any existing 'Time' column is overwritten.}

\item{separator}{character for the delimiter used to separate columns
(see 'sep' in \code{\link{read.table}} for details).}

\item{ignore.case}{logical indicating if case should be ignored. Only applies
to multiple file import option.}

\item{auto.trim}{logical indicating if dataset should be trimmed.}

\item{trim.samples}{character vector with sample names to trim.}

\item{trim.invert}{logical to keep (TRUE) or remove (FALSE) samples.}

\item{auto.slim}{logical indicating if dataset should be slimmed.}

\item{slim.na}{logical indicating if rows without data should remain.}

\item{na.strings}{character vector with strings to be replaced by NA.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with imported result.
}
\description{
Import text files and apply post processing.
}
\details{
Imports text files (e.g. GeneMapper results exported as text files)
as data frames. Options to import one or multiple files. For multiple
files it is possible to specify prefix, suffix, and file extension
to create a file name filter. The file name and/or file time stamp
can be imported.
NB! Empty strings ("") and NA strings ("NA") are converted to NA.
See \code{\link{list.files}} and \code{\link{read.table}} for additional details.
}
\seealso{
\code{\link{trim}}, \code{\link{slim}}, \code{\link{list.files}}, \code{\link{read.table}}
}
