% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicSemanticCoherence.R
\name{topicSemanticCoherence}
\alias{topicSemanticCoherence}
\title{Semantic Coherence}
\usage{
topicSemanticCoherence(beta, documents, vocab, M = 10)
}
\arguments{
\item{beta}{the beta probability  matrix (topic-word distributions) for a given document or alpha-level}

\item{documents}{the documents over which to calculate coherence}

\item{vocab}{the vocabulary corresponding to the terms in the beta matrix}

\item{M}{the number of top words to consider per topic}
}
\value{
a numeric vector containing semantic coherence for each topic
}
\description{
Calculates semantic coherence for an STS model.
}
\examples{
#An example using the Gadarian data from the stm package.  From Raw text to 
# fitted model using textProcessor() which leverages the tm Package
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
out$meta$noTreatment <- ifelse(out$meta$treatment == 1, -1, 1)
## low max iteration number just for testing
sts_estimate <- sts(~ treatment*pid_rep, ~ noTreatment, out, K = 3, maxIter = 2)
full_beta_distn <- exp(sts_estimate$mv + sts_estimate$kappa$kappa_t + 
sts_estimate$kappa$kappa_s \%*\% diag(apply(sts_estimate$alpha[,3:5], 2, mean)))
full_beta_distn <- t(apply(full_beta_distn, 1, 
function(m) m / colSums(full_beta_distn)))
topicSemanticCoherence(full_beta_distn, out$documents, out$vocab)
}
