% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stylest_fit.R
\name{stylest_fit}
\alias{stylest_fit}
\title{Fit speaker_model to a corpus}
\usage{
stylest_fit(x, speaker, terms = NULL, filter = NULL, smooth = 0.5)
}
\arguments{
\item{x}{Text vector. May be a \code{corpus_frame} object}

\item{speaker}{Vector of speaker labels. Should be the same length as
\code{x}}

\item{terms}{If not \code{NULL}, terms to be used in the model. If
\code{NULL}, use all terms}

\item{filter}{If not \code{NULL}, a text filter to specify the tokenization.
See \code{corpus} for more information about specifying \code{filter}}

\item{smooth}{Numeric value used smooth term frequencies instead of the
default of 0.5}
}
\value{
A S3 \code{stylest_model} object containing:
\code{speakers} Vector of unique speakers,
\code{filter} text_filter used,
\code{terms} terms used in fitting the model,
\code{ntoken} Vector of number of tokens per speaker,
\code{smooth} Smoothing value,
\code{rate} Matrix of speaker rates for each term in vocabulary
}
\description{
The main function in \code{stylest}, \code{stylest_fit} fits a
model using a corpus of texts labeled by speaker.
}
\details{
The user may specify only one of \code{terms} or \code{cutoff}.
If neither is specified, all terms will be used.
}
\examples{
data(novels_excerpts)
speaker_mod <- stylest_fit(novels_excerpts$text, novels_excerpts$author)

}
