% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bernoulli_ARL.R
\name{calc_Wncdf}
\alias{calc_Wncdf}
\title{Calculate cdf of singletons W_n for CUSUM}
\usage{
calc_Wncdf(glmmod, theta, theta_true, p0, smooth_prob = FALSE)
}
\arguments{
\item{glmmod}{Generalized linear regression model used for risk-adjustment as produced by
the function \code{\link[stats:glm]{glm()}}. Suggested: \cr
\code{glm(as.formula("(survtime <= followup) & (censorid == 1) ~ covariates"), data = data)}. \cr
Alternatively, a list containing the following elements:
\describe{
\item{\code{formula}:}{a \code{\link[stats:formula]{formula()}} in the form \code{~ covariates};}
\item{\code{coefficients}:}{a named vector specifying risk adjustment coefficients
for covariates. Names must be the same as in \code{formula} and colnames of \code{data}.}
}}

\item{theta}{The \eqn{\theta}{\theta} value used to specify the odds ratio
\eqn{e^\theta}{e^\theta} under the alternative hypothesis.
If \eqn{\theta >= 0}{\theta >= 0}, the average run length for the upper one-sided
Bernoulli CUSUM will be determined. If \eqn{\theta < 0}{\theta < 0},
the average run length for the lower one-sided CUSUM will be determined.
Note that \deqn{p_1 = \frac{p_0 e^\theta}{1-p_0 +p_0 e^\theta}.}{p1 = (p0 * e^\theta)/(1-p0+p0 * e^\theta).}}

\item{theta_true}{The true log odds ratio \eqn{\theta}{\theta}, describing the
true increase in failure rate from the null-hypothesis. Default = log(1), indicating
no increase in failure rate.}

\item{p0}{The baseline failure probability at \code{entrytime + followup} for individuals.}

\item{smooth_prob}{Should the probability distribution of failure under the null distribution be smoothed?
Useful for small samples. Can only be TRUE when \code{glmmod} is supplied. Default = FALSE.}
}
\description{
Internal function to calculate cdf of singletons \eqn{W_n}{Wn}
of the Bernoulli CUSUM chart. The cdf is used to create the transition matrix
when Markov Chain methodology is used or to determine the integral equation/probabilities
of a Wald test when integral equation or Kemp's methodology is used.
}
\keyword{internal}
