% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closest_focal_point.R
\name{closest_focal_point}
\alias{closest_focal_point}
\title{For the polygon provided, find the closest focal point in the set provided}
\usage{
closest_focal_point(centroid, focal_points)
}
\arguments{
\item{centroid}{a data frame describing one centroid}

\item{focal_points}{a data frame of the longitude and latitude values}
}
\value{
data frame containing the name and location of the closest focal
}
\description{
For one row of an sf data frame, calculate the distance to the closest focal
point. Return the name of the focal point, and the angle between focal point and centroid.
}
\examples{
# Create a set of polygon centroids
centroids <- create_centroids(tas_sa2, "SA2_5DIG16")

# Find the closest capital city for the first centroid
closest_focal_point(centroids[1, ], capital_cities)
}
