% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_named_vctr.R
\name{check_named_vctr}
\alias{check_named_vctr}
\title{Check a named vector}
\usage{
check_named_vctr(x, names, default)
}
\arguments{
\item{x}{A named vector.}

\item{names}{A character vector specifying the names to be matched.}

\item{default}{Default value to return}
}
\value{
Either the original object, \code{x}, or the \code{default} value.
}
\description{
This function assesses whether named lists and vectors have
invalid values (like \code{NULL} or \code{NA}), invalid names (such as missing or
empty names), confirms that the count of valid names matches the count of
provided values, and verifies that the valid names obtained from the named
object align with the supplied names. If any checks fail, the \code{default}
value is returned.
}
\examples{

# returns NULL
check_named_vctr(x = c(one = 1, two = 2, 3), 
                 names = c("one", "two", "three"),
                 default = NULL)
                 
# returns x
check_named_vctr(x = list(one = 1, two = 2, three = 3), 
                 names = list("one", "two", "three"),
                 default = NULL)               
                 
}
\author{
Ama Nyame-Mensah
}
