% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_args.R
\name{parse_args}
\alias{parse_args}
\title{Extract Data Information From Arguments Passed to Functions}
\usage{
parse_args(sys_calls, sys_frames, match_call, var = "x",
  silent = FALSE, df_name = TRUE, df_label = TRUE, var_name = TRUE,
  var_label = TRUE, caller = "")
}
\arguments{
\item{sys_calls}{Object created using \code{sys.calls()}.}

\item{sys_frames}{Object created using \code{sys.frames()}.}

\item{match_call}{Object created using \code{match.call()}.}

\item{var}{Character. \dQuote{x} (default) and/or \dQuote{y} (the latter 
being used only in \code{\link{ctable}}).}

\item{silent}{Logical. Hide console messages. \code{TRUE} by default.}
}
\value{
A list consisting of one or many of the following items
\itemize{
  \item df_name The data frame name
  \item df_label The data frame label
  \item var_name The variable name(s)
  \item var_label The variable label
  \item by_var The variable used in \code{by()}, when in the call stack
  \item by_group The group, when \code{by()} was used
  \item by_first Binary indicator used when \code{by()} is in the call stack
  \item by_last Binary indicator}
}
\description{
Using sys.calls(), sys.frames() and match.call(), this utility function
extracts and/or deducts information about the data being processed.
Data frame name, variable names and labels if any, subsetting information,
grouping information (when by() is used) are returned by the function which
tries various methods to get this information.
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com>}
}
\keyword{internal}
\keyword{misc}
