% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_keywords.R
\name{define_keywords}
\alias{define_keywords}
\title{Modify Keywords Used In Outputs}
\usage{
define_keywords(..., ask = FALSE, file = NA)
}
\arguments{
\item{\dots}{One or more pairs of keywords and their new values see 
\emph{Details} for the complete list of existing keywords.}

\item{ask}{Logical. When `TRUE` (default), a dialog box comes up to ask
whether to save the edited values in a csv file for later use.}

\item{file}{Character. Path and name of custom language file to be saved.
This comma delimited file can be reused by calling
\code{\link{use_custom_lang}}.}
}
\description{
As an alternative to \code{\link{use_custom_lang}}, this function allows
temporarily modifying the pre-defined terms in the outputs.
}
\details{
On systems with GUI capabilities, a window will pop-up when calling 
\code{define_keywords()} without any parameters, allowing the modification 
of the \emph{custom} column. The changes will be active as long as the
package is loaded. When the edit window is closed, a dialog will pop up,
prompting the user to save the modified set of keywords in a custom csv
language file that can later be used with \code{\link{use_custom_lang}}.

Here is the full list of modifiable keywords.
  
\describe{
  \item{title.freq}{main heading for \code{freq()}}
  \item{title.freq.weighted}{main heading for \code{freq()} (weighted)}
  \item{title.ctable}{main heading for \code{ctable()}}
  \item{title.ctable.weighted}{main heading \code{ctable()} (weighted)}
  \item{title.ctable.row}{indicates what proportions are displayed}
  \item{title.ctable.col}{indicates what proportions are displayed}
  \item{title.ctable.tot}{indicates what proportions are displayed}
  \item{title.descr}{main heading for \code{descr()}}
  \item{title.descr.weighted}{main heading for \code{descr()} (weighted)}
  \item{title.dfSummary}{main heading for \code{dfSummary()}}
  \item{n}{heading item used in \code{descr()}}
  \item{dimensions}{heading item used in \code{dfSummary()}}
  \item{duplicates}{heading item used in \code{dfSummary()}}
  \item{data.frame}{heading item (all functions)}
  \item{label}{heading item (all functions) & column name in \code{dfSummary()}}
  \item{variable}{heading item (all functions) & column name in \code{dfSummary()}}
  \item{group}{heading item (all functions when used with \code{stby()}}
  \item{by}{heading item for \code{descr()} when used with stby()}
  \item{weights}{heading item - \code{descr()} & \code{freq()}}
  \item{type}{heading item for \code{freq()}}
  \item{logical}{heading item - type in \code{freq()}}
  \item{character}{heading item - type in \code{freq()}}
  \item{numeric}{heading item - type in \code{freq()}}
  \item{factor}{heading item - type in \code{freq()}}
  \item{factor.ordered}{heading item - type in \code{freq()}}
  \item{date}{heading item - type in \code{freq()}}
  \item{datetime}{heading item - type in \code{freq()}}
  \item{freq}{column name in \code{freq()}}
  \item{pct}{column name in \code{freq()} when \code{report.nas=FALSE}}
  \item{pct.valid.f}{column name in \code{freq()}}
  \item{pct.valid.cum}{column name in \code{freq()}}
  \item{pct.total}{column name in \code{freq()}}
  \item{pct.total.cum}{column name in \code{freq()}}
  \item{pct.cum}{column name in \code{freq()}}
  \item{valid}{column name in \code{freq()} and \code{dfSummary()} & column content in \code{dfSummary()}}
  \item{invalid}{column content in \code{dfSummary()} (emails)}
  \item{total}{column grouping in \code{freq()}, html version}
  \item{mean}{row name in \code{descr()}}
  \item{sd.long}{row name in \code{descr()}}
  \item{sd}{cell content (dfSummary)}
  \item{min}{row name in \code{descr()}}
  \item{q1}{row name in \code{descr()} - 1st quartile}
  \item{med}{row name in \code{descr()}}
  \item{q3}{row name in \code{descr()} - 3rd quartile}
  \item{max}{row name in \code{descr()}}
  \item{mad}{row name in \code{descr()} - Median Absolute Deviation}
  \item{iqr}{row name in \code{descr()} - Inter-Quartile Range}
  \item{cv}{row name in \code{descr()} - Coefficient of Variation}
  \item{skewness}{row name in \code{descr()}}
  \item{se.skewness}{row name in \code{descr()} - Std. Error for Skewness}
  \item{kurtosis}{row name in \code{descr()}}
  \item{n.valid}{row name in \code{descr()} - Count of non-missing values}
  \item{pct.valid}{row name in \code{descr()} - pct. of non-missing values}
  \item{no}{column name in \code{dfSummary()} - position of column in the data frame}
  \item{stats.values}{column name in \code{dfSummary()}}
  \item{freqs.pct.valid}{column name in \code{dfSummary()}}
  \item{graph}{column name in \code{dfSummary()}}
  \item{missing}{column name in \code{dfSummary()}}
  \item{distinct.value}{cell content in \code{dfSummary()} - singular form}
  \item{distinct.values}{cell content in \code{dfSummary()} - plural form}
  \item{all.nas}{cell content in \code{dfSummary()} - column has only NAs}
  \item{all.empty.str}{cell content in \code{dfSummary()} - column has only empty strings}
  \item{all.empty.str.nas}{cell content in \code{dfSummary()} - col. has only NAs and empty strings}
  \item{no.levels.defined}{cell content in \code{dfSummary()} - factor has no levels defined}
  \item{int.sequence}{cell content in \code{dfSummary()}}
  \item{rounded}{cell content in \code{dfSummary()} - note appearing in Stats/Values}
  \item{others}{cell content in \code{dfSummary()} - nbr of values not displayed}
  \item{codes}{cell content in \code{dfSummary()} - When UPC codes are detected}
  \item{mode}{cell content in \code{dfSummary()} - mode = most frequent value}
  \item{med.short}{cell content in \code{dfSummary()} - median (shortened term)}
  \item{start}{cell content in \code{dfSummary()} - earliest date for date-type cols}
  \item{end}{cell content in \code{dfSummary()} - latest date for data-type cols}
  \item{emails}{cell content in \code{dfSummary()}}
  \item{generated.by}{footnote content}
  \item{version}{footnote content}
  \item{date.fmt}{footnote - date format (see \code{\link{strptime}})}
}
}
\note{
Setting a keyword starting with \dQuote{title.} to NA or to empty
string causes the main title to disappear altogether, which might be
desired in some circumstances (when generating a table of contents, for
instance).
}
\examples{
\dontrun{
define_keywords(n = "Nb. Obs.")
} 

}
\keyword{utilities}
