% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summclust.R
\name{summclust}
\alias{summclust}
\title{Compute Influence and Leverage Metrics}
\usage{
summclust(obj, ...)
}
\arguments{
\item{obj}{An object of class \code{lm} or \code{fixest}}

\item{...}{Other arguments}
}
\value{
An object of type \code{summclust}, including
a CRV3 variance-covariance estimate as described in
MacKinnon, Nielsen & Webb (2022)
}
\description{
Compute influence and leverage metrics for clustered inference
based on the Cluster Jackknife described in MacKinnon, Nielsen & Webb
(2022).
}
\examples{

\donttest{
if(requireNamespace("summclust") && requireNamespace("haven")){

library(summclust)
library(haven)

nlswork <- read_dta("http://www.stata-press.com/data/r9/nlswork.dta")
# drop NAs at the moment
nlswork <- nlswork[, c("ln_wage", "grade", "age", "birth_yr", "union", "race", "msp", "ind_code")]
nlswork <- na.omit(nlswork)

lm_fit <- lm(
  ln_wage ~ union +  race + msp + as.factor(birth_yr) + as.factor(age) + as.factor(grade),
  data = nlswork)

res <- summclust(
   obj = lm_fit,
   params = c("msp", "union"),
   cluster = ~ind_code,
 )

 summary(res)
 tidy(res)
 plot(res)
}
}
}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
\seealso{
\link[summclust]{summclust.lm},
\link[summclust]{summclust.fixest}
}
