% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summclust.R
\name{plot.summclust}
\alias{plot.summclust}
\title{Plotting method for objects of type \code{summclust}}
\usage{
\method{plot}{summclust}(x, ...)
}
\arguments{
\item{x}{An object of type \code{summclust}}

\item{...}{other optional function arguments}
}
\value{
A list containing
\item{residual_leverage}{A \code{ggplot} of the residual leverages}
\item{coef_leverage}{A \code{ggplot} of the coefficient leverages}
\item{coef_beta}{A \code{ggplot} of the leave-one-out cluster jackknife
regression coefficients}
}
\description{
Plots residual leverage, partial leverage and the
leave-one-cluster-out regression coefficients
}
\details{
Note that the function requires \code{ggplot2} to be installed.
}
\examples{

library(summclust)
data(mtcars)
mtcars

fit <- lm(mpg ~ cyl + disp + hp, data = mtcars)
summ <- summclust(fit, params = ~cyl + disp, cluster = ~carb)
summary(summ)
tidy(summ)
plot(summ)

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
