% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listwise_delete.R
\name{listwise_delete}
\alias{listwise_delete}
\alias{listwise_delete.data.frame}
\alias{listwise_delete.lm}
\title{Remove cases with missing values.}
\usage{
listwise_delete(obj, vars)

\method{listwise_delete}{data.frame}(obj, vars = names(obj))

\method{listwise_delete}{lm}(obj, vars = all.vars(formula(obj)))
}
\arguments{
\item{obj}{The \code{\link{data.frame}} or \code{\link{lm}} object to process.}

\item{vars}{The variables to consider.}
}
\value{
For \code{data.frame}s, the \code{vars} are checked for missing values. If one is found on any of
the variables, the entire row is removed (list-wise deletion). For linear models, the model is
refit after the underlying data have been processed.
}
\description{
Remove cases with missing values.
}
