% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.surbayes.R
\name{predict.surbayes}
\alias{predict.surbayes}
\title{Get predictive posterior samples}
\usage{
\method{predict}{surbayes}(object, newdata, nsims = 1, ...)
}
\arguments{
\item{object}{Result from calling \code{sur_sample}}

\item{newdata}{\code{data.frame} of new data}

\item{nsims}{number of posterior draws to take. The default and minimum is 1. The maximum is the number of simulations in surbayes}

\item{...}{further arguments passed to or from other methods}
}
\value{
\code{n x J x nsims} \code{array} of predicted values
}
\description{
This function returns a list of new data sets by sampling
from the posterior predictive density of Y | Y0, Xnew.
}
\examples{

## Taken from bayesm package
if(nchar(Sys.getenv("LONG_TEST")) != 0) {M=1000} else {M=10}
set.seed(66)
## simulate data from SUR
beta1 = c(1,2)
beta2 = c(1,-1,-2)
nobs = 100
nreg = 2
iota = c(rep(1, nobs))
X1 = cbind(iota, runif(nobs))
X2 = cbind(iota, runif(nobs), runif(nobs))
Sigma = matrix(c(0.5, 0.2, 0.2, 0.5), ncol = 2)
U = chol(Sigma)
E = matrix( rnorm( 2 * nobs ), ncol = 2) \%*\% U
y1 = X1 \%*\% beta1 + E[,1]
y2 = X2 \%*\% beta2 + E[,2]
X1 = X1[, -1]
X2 = X2[, -1]
data = data.frame(y1, y2, X1, X2)
names(data) = c( paste0( 'y', 1:2 ), paste0('x', 1:(ncol(data) - 2) ))
## run DMC sampler
formula.list = list(y1 ~ x1, y2 ~ x2 + x3)

## Fit model
out = sur_sample( formula.list, data, M = M )

## Obtain predictions
pred = predict(out, data, nsims = 1)

}
