% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{SurvFctCoxExp}
\alias{SurvFctCoxExp}
\title{Survival curves of simulated data with Cox/Exponential model}
\usage{
SurvFctCoxExp(Z, beta, pp, Ts, hazParams)
}
\arguments{
\item{Z}{Matrix of covariates}

\item{beta}{regression parameter}

\item{pp}{number of pertinent covariates}

\item{Ts}{observed times}

\item{hazParams}{distribution parameters of baseline hazard risk}

\item{Y}{random uniform}
}
\value{
SurvFctCoxExp returns a list containing: \itemize{
\item{St}{ Matrix of survival functions (rows: individuals, columns: time grid)}
\item{Ft}{ Matrix of cumulative functions (rows: individuals, columns: time grid)}
\item{H0t}{ Matrix of cumulative hazard functions (rows: individuals, columns: time grid)}
\item{ht}{ Matrix of hazard risk functions (rows: individuals, columns: time grid)}
\item{grillet}{ Time grid}
\item{tau}{ maximum of observed times}
}
}
\description{
Survival curves of simulated data with Cox/Exponential model
}
\examples{
library(survMS)
}
\keyword{internal}
