% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.stand_surveil}
\alias{print.stand_surveil}
\alias{plot.stand_surveil}
\title{Methods for standardized rates}
\usage{
\method{print}{stand_surveil}(x, scale = 1, digits = 3, ...)

\method{plot}{stand_surveil}(
  x,
  scale = 1,
  style = c("mean_qi", "lines"),
  M = 250,
  base_size = 14,
  col = "black",
  fill = "gray80",
  alpha,
  lwd,
  ...
)
}
\arguments{
\item{x}{An object of \code{stand_surveil} obtained by calling \code{\link[surveil]{standardize}} on a fitted \code{surveil} model}

\item{scale}{Scale the rates by this amount; e.g., \code{scale = 100e3} will print rates per 100,000 at risk.}

\item{digits}{Number of digits to print}

\item{...}{additional arguments}

\item{style}{If \code{style = "mean_qi"}, then the posterior means and 95 percent credible intervals will be plotted; if \code{style = "lines"}, then \code{M} samples from the joint posterior distribution will be plotted.}

\item{M}{Number of samples to plot when \code{style = "lines"}}

\item{base_size}{Passed to \code{theme_classic()} to control size of plot components (text).}

\item{col}{Line color}

\item{fill}{Fill color for the 95 percent credible intervals}

\item{alpha}{For \code{style = "mean_qi"}, this controls the transparency for the credible interval (passed to \code{\link[ggplot2]{geom_ribbon}}) and defaults to \code{alpha = 0.5}; for \code{style = "lines"}, this controls the transparency of the lines and defaults to \code{alpha = 0.7}.}

\item{lwd}{Line width; for \code{style = "mean_qi"}, the default is \code{lwd = 1}; for \code{style = "lines"}, the default is \code{lwd = 0.05}.}
}
\value{
\subsection{print.stand_surveil}{

The print method returns nothing but prints a summary of results to the console.
}

\subsection{plot.stand_surveil}{

The plot method returns an object of class \code{ggplot}.
}
}
\description{
Print and plot methods for \code{stand_surveil} (standardized rates obtained from a fitted \code{surveil} model)
}
\details{
Calling \code{standardize} on a fitted \code{surveil} model will create a new object that contains the \code{surveil} model results as well standardized rates. This new \code{stand_surveil} object has its own methods for printing and plotting.
\subsection{print.stand_surveil}{

Any additional arguments (\code{...}) will be  passed to \code{\link[base]{print.data.frame}}
}

\subsection{plot.stand_surveil}{

Any additional arguments (\code{...}) will be passed to `\code{\link[ggplot2]{theme}}.
}
}
\seealso{
\code{\link[surveil]{standardize}} \code{\link[surveil]{stan_rw}}
}
