% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.svydesign.R
\name{cv.svydesign}
\alias{cv.svydesign}
\title{CV for \code{svydesign} objects}
\usage{
cv.svydesign(
  design_object,
  formulae,
  nfolds = 5,
  method = c("linear", "logistic")
)
}
\arguments{
\item{design_object}{Name of a \code{svydesign} object created using the \code{survey}
package. The argument \code{id} (also \code{strata}, \code{fpc}, and/or \code{weights} if used)
must be specified as formulas, e.g. \code{svydesign(ids = ~MyPSUs, ...)}.
We do not yet support use of \code{probs} or \code{pps}.}

\item{formulae}{Vector of formulas (as strings) for the GLMs to be compared in
cross validation}

\item{nfolds}{Number of folds to be used during cross validation, defaults to
5}

\item{method}{String, must be either "linear" or "logistic", determines type of
model fit during cross validation, defaults to linear}
}
\value{
Object of class \code{svystat}, which is a named vector of survey CV estimates of the mean loss
  (MSE for linear models, or binary cross-entropy for logistic models) for each model,
  with names ".Model_1", ".Model_2", etc. corresponding to the models provided in \code{formulae};
  and with a \code{var} attribute giving the variances.
  See \code{\link[survey]{surveysummary}} for details.
}
\description{
Wrapper function which takes a \code{\link[survey]{svydesign}} object
and a vector of model formulas (as strings),
and passes it into \code{\link{cv.svy}}.
Returns survey CV estimates of the mean loss for each model
(MSE for linear models, or binary cross-entropy for logistic models).
If you have already fitted a \code{svyglm},
you may prefer the convenience wrapper function
\code{\link{cv.svyglm}}.
}
\examples{
# Compare CV MSEs and their SEs under 3 models
# for a stratified sample and a one-stage cluster sample,
# from the `survey` package
library(survey)
data("api", package = "survey")
# stratified sample
dstrat <- svydesign(id = ~1, strata = ~stype, weights = ~pw, data = apistrat,
                    fpc = ~fpc)
cv.svydesign(formulae = c("api00~ell",
                          "api00~ell+meals",
                          "api00~ell+meals+mobility"),
             design_object = dstrat, nfolds = 5)
# one-stage cluster sample
dclus1 <- svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)
cv.svydesign(formulae = c("api00~ell",
                          "api00~ell+meals",
                          "api00~ell+meals+mobility"),
             design_object = dclus1, nfolds = 5)

# Compare CV MSEs and their SEs under 3 models
# for a stratified cluster sample with clusters nested within strata
data(NSFG_data)
library(splines)
NSFG.svydes <- svydesign(id = ~SECU, strata = ~strata, nest = TRUE,
                         weights = ~wgt, data = NSFG_data)
cv.svydesign(formulae = c("income ~ ns(age, df = 2)",
                          "income ~ ns(age, df = 3)",
                          "income ~ ns(age, df = 4)"),
             design_object = NSFG.svydes, nfolds = 4)
}
\seealso{
\code{\link[survey]{surveysummary}}, \code{\link[survey]{svydesign}}

\code{\link{cv.svyglm}} for a wrapper to use with a \code{svyglm} object
}
