% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_feature_data.R
\name{simulate_feature_data}
\alias{simulate_feature_data}
\title{Simulate feature data}
\usage{
simulate_feature_data(n_features, proportion_of_survey_features = 1)
}
\arguments{
\item{n_features}{\code{integer} number of features.}

\item{proportion_of_survey_features}{\code{numeric} proportion of features
that will be examined in the new surveys. Values must be between
zero and one. Defaults to 1 such that all features should be surveyed.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble()}} object. It contains the following
data:
\describe{
\item{\code{name}}{\code{character} name of each feature.}

\item{\code{survey}}{\code{logical} (\code{TRUE} / \code{FALSE}) values
indicating if each feature should be examined in surveys or not.}

\item{\code{survey_sensitivity}}{\code{numeric} sensitivity (true positive
rate) of the survey methodology for each features.}

\item{\code{survey_specificity}}{\code{numeric} specificity (true negative
rate) of the survey methodology for each features.}

\item{\code{model_sensitivity}}{\code{numeric} specificity (true positive
rate) of the occupancy models for each features.}

\item{\code{model_specificity}}{\code{numeric} specificity (true negative
rate) of the occupancy models for each features.}

\item{\code{target}}{\code{numeric} target values used to parametrize
the conservation benefit of managing of each feature (defaults to 1).}

}
}
\description{
Simulate feature data for developing simulated survey schemes.
}
\examples{
# set seed for reproducibility
set.seed(123)

# simulate data
d <- simulate_feature_data(n_features = 5,
                           proportion_of_survey_features = 0.5)
# print data
print(d, width = Inf)

}
\seealso{
\code{\link[=simulate_site_data]{simulate_site_data()}}
}
