% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{survivor_pal}
\alias{survivor_pal}
\alias{scale_fill_survivor}
\alias{scale_colour_survivor}
\title{Survivor season colour palette}
\usage{
survivor_pal(season = NULL, scale_type = "d", reverse = FALSE, ...)

scale_fill_survivor(season = NULL, scale_type = "d", reverse = FALSE, ...)

scale_colour_survivor(season = NULL, scale_type = "d", reverse = FALSE, ...)
}
\arguments{
\item{season}{Season number}

\item{scale_type}{Discrete or continuous.  Input \code{d} or \code{c}.}

\item{reverse}{Logical. Reverse the palette?}

\item{...}{Other arguments passed on to methods.}
}
\value{
Scale functions for ggplot2




}
\description{
\code{ggplot2} scales for each season of Survivor.
}
\details{
Palettes are created from the logo for the season.
}
\examples{
library(ggplot2)
library(dplyr)
mpg \%>\%
  ggplot(aes(x = displ, fill = manufacturer)) +
  geom_histogram(colour = "black") +
  scale_fill_survivor(40)
}
