% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_class.R
\name{sfx}
\alias{sfx}
\alias{hfx}
\alias{Cum_Hfx}
\alias{invCum_Hfx}
\alias{rsurv}
\alias{rsurvhr}
\alias{plot_survival}
\alias{ggplot_survival_random}
\alias{compare_survival}
\title{Functions for SURVIVAL objects}
\usage{
sfx(SURVIVAL, t)

hfx(SURVIVAL, t)

Cum_Hfx(SURVIVAL, t)

invCum_Hfx(SURVIVAL, H)

rsurv(SURVIVAL, n)

rsurvhr(SURVIVAL, hr)

plot_survival(SURVIVAL, timeto, main)

ggplot_survival_random(SURVIVAL, timeto, subjects, nsim, alpha = 0.1)

compare_survival(SURVIVAL1, SURVIVAL2, timeto, main)
}
\arguments{
\item{SURVIVAL}{a SURVIVAL object}

\item{t}{Time}

\item{H}{cumulative hazard}

\item{n}{number of observations}

\item{hr}{a vector with hazard rates.}

\item{timeto}{timeto used in the graphs}

\item{main}{title of the graph}

\item{subjects}{number of subjects to simulate in each simulation}

\item{nsim}{number of simulations}

\item{alpha}{alpha value for the graph}

\item{SURVIVAL1}{a SURVIVAL object}

\item{SURVIVAL2}{a SURVIVAL object}
}
\value{
Depending on the function a proportion surviving, hazard,
cumulative hazard, inverse of the cumulative hazard, a random draw or a plot
}
\description{
All the SURVIVAL objects have access to the functions described here
}
\section{Functions}{
\itemize{
\item \code{sfx()}: Survival function

\item \code{hfx()}: Hazard function

\item \code{Cum_Hfx()}: Cumulative Hazard function

\item \code{invCum_Hfx()}: Inverse of the Cumulative Hazard function

\item \code{rsurv()}: Generate random values from the distribution

\item \code{rsurvhr()}: Generate random values from the distribution under proportional hazard ratios

\item \code{plot_survival()}: Plot of the survival functions

\item \code{ggplot_survival_random()}: ggplot of the simulation of survival times

\item \code{compare_survival()}: Compare graphically two survival distributions

}}
\examples{
#' # Define a SURVIVAL object
obj <- s_factory(s_weibull, surv = 0.8, t = 2, shape = 1.2)

# Survival, Hazard and Cumulative hazard at time 0.4
sfx(SURVIVAL = obj, t= 0.4)
hfx(SURVIVAL = obj, t = 0.4)
Cum_Hfx(SURVIVAL = obj, t = 0.4)

# Time when the Cumulative hazard is 0.8
invCum_Hfx(SURVIVAL = obj, H = 0.8)

# Draw one random survival time from the distribution
rsurv(SURVIVAL = obj, n = 1)

# Draw one random survival time from the distribution, with hazard ratio 0.5
rsurvhr(SURVIVAL = obj, hr = 0.5)

# Plot the survival functions
plot_survival(SURVIVAL = obj, timeto = 2, main = "Example of Weibull distribution" )

}
