% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ypreg.R
\name{ypreg}
\alias{ypreg}
\title{Fitting Yang and Prentice Models}
\usage{
ypreg(formula, data, baseline = "weibull", dist = NULL, init = 0, ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{data an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which function is called.}

\item{baseline}{the chosen baseline distribution; options currently available are: exponential, weibull, lognormal, loglogistic and Birnbaum-Saunders (fatigue) distributions.}

\item{dist}{alternative way to specify the baseline distribution (for compatibility with the \code{\link[survival]{survreg}} function); default is NULL.}

\item{init}{initial values specification (default value is 0); see the detailed documentation for \code{init} in \code{\link[rstan]{optimizing}}.}

\item{...}{further arguments passed to other methods.}
}
\value{
ypreg returns an object of class "ypreg" containing the fitted model.
}
\description{
Function to fit Yang and Prentice (YP) models.
}
\examples{
\donttest{
library(survstan)
fit <- ypreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull")
summary(fit)
}


}
