% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_survfit.R
\name{plot_survfit}
\alias{plot_survfit}
\title{Plot a survfit object}
\usage{
plot_survfit(fit, lwd = 1, xmax = NULL, xbreaks = NULL,
  ylim = NULL, ci = FALSE, cuminc = TRUE, y_percent = TRUE,
  split_legend_labels = TRUE, legend.title = NA,
  legend.position = "top")
}
\arguments{
\item{fit}{A survfit object that we should plot}

\item{lwd}{Line width}

\item{xmax}{What is the upper limit of the X axis? The default will plot all data.}

\item{xbreaks}{A numeric vector. Where should the breaks in the X axis be? The default will give ggplot's
default breaks.}

\item{ylim}{A numeric vector of length 2. Which are the Y axis limits?}

\item{ci}{A logical scalar. Should confidence intervals be plotted?}

\item{cuminc}{A logical scalar. Should cumulative incidence be plotted (default), or should be survival
be plotted instead (cuminc = FALSE)?}

\item{y_percent}{A logical scalar. Should the Y axis display percentages?}

\item{split_legend_labels}{A logical scalar. Should the legends labels be split, i.e. removing the "<variable_name>="
for each stratum?}

\item{legend.title}{What title should the legend have? By default it will take the value that was split if split_legend_labels
was used; otherwise it will take the value "strata"}

\item{legend.position}{Where should the legend be drawn? Possible answers are: "top", "bottom",
"left", "right"; or if you want to skip putting a legend on the plot: "none"}
}
\value{
Returns a ggplot object
}
\description{
Creates a Kaplan-Meier plot based on a survfit object
}
\examples{

library(survsup); library(ggplot2); library(dplyr); library(survival)

retinopathy \%>\%
    survfit(Surv(futime, status) ~ trt, data = .) \%>\%
   plot_survfit()

retinopathy \%>\%
    survfit(Surv(futime, status) ~ trt, data = .) \%>\%
   plot_survfit(ci = TRUE, cuminc = FALSE)

# Since a ggplot object is returned,
# you can tweak as you wish
# (in this case with multiple labels):
mgus2 \%>\%
     survfit(Surv(futime, death) ~ sex, data = .) \%>\%
     plot_survfit(cuminc = FALSE) \%>\%
     nar(flip = TRUE) \%>\%
     hcl_rainbow()+  # <--- Notice + sign here!
     labs(title = "This is an excessively long title",
     	subtitle = "This is a subtitle",
     	x = "Time (days)",
     	y = "Survival (\%)",
     	caption = "(This is a demo)")
}
\author{
Daniel Lindholm
}
